/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.liquibase;

import org.springframework.boot.autoconfigure.liquibase.LiquibaseConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.JdbcDatabaseContainer;

class LiquibaseContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<JdbcDatabaseContainer<?>, LiquibaseConnectionDetails> {
    LiquibaseContainerConnectionDetailsFactory() {
    }

    @Override
    protected LiquibaseConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<JdbcDatabaseContainer<?>> source) {
        return new LiquibaseContainerConnectionDetails(source);
    }

    private static final class LiquibaseContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<JdbcDatabaseContainer<?>>
    implements LiquibaseConnectionDetails {
        private LiquibaseContainerConnectionDetails(ContainerConnectionSource<JdbcDatabaseContainer<?>> source) {
            super(source);
        }

        public String getUsername() {
            return ((JdbcDatabaseContainer)this.getContainer()).getUsername();
        }

        public String getPassword() {
            return ((JdbcDatabaseContainer)this.getContainer()).getPassword();
        }

        public String getJdbcUrl() {
            return ((JdbcDatabaseContainer)this.getContainer()).getJdbcUrl();
        }

        public String getDriverClassName() {
            return ((JdbcDatabaseContainer)this.getContainer()).getDriverClassName();
        }
    }
}

