/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.ldap;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.ldap.LdapConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Container;

class OpenLdapContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, LdapConnectionDetails> {
    OpenLdapContainerConnectionDetailsFactory() {
        super("osixia/openldap", new String[0]);
    }

    @Override
    protected LdapConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new OpenLdapContainerConnectionDetails(source);
    }

    private static final class OpenLdapContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements LdapConnectionDetails {
        private OpenLdapContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        public String[] getUrls() {
            Map env = this.getContainer().getEnvMap();
            boolean usesTls = Boolean.parseBoolean(env.getOrDefault("LDAP_TLS", "true"));
            String ldapPort = usesTls ? env.getOrDefault("LDAPS_PORT", "636") : env.getOrDefault("LDAP_PORT", "389");
            return new String[]{"%s://%s:%d".formatted(usesTls ? "ldaps" : "ldap", this.getContainer().getHost(), this.getContainer().getMappedPort(Integer.parseInt(ldapPort)))};
        }

        public String getBase() {
            Map env = this.getContainer().getEnvMap();
            if (env.containsKey("LDAP_BASE_DN")) {
                return (String)env.get("LDAP_BASE_DN");
            }
            return Arrays.stream(env.getOrDefault("LDAP_DOMAIN", "example.org").split("\\.")).map(arg_0 -> OpenLdapContainerConnectionDetails.lambda$getBase$0("dc=%s", arg_0)).collect(Collectors.joining(","));
        }

        public String getUsername() {
            return "cn=admin,%s".formatted(this.getBase());
        }

        public String getPassword() {
            return this.getContainer().getEnvMap().getOrDefault("LDAP_ADMIN_PASSWORD", "admin");
        }

        private static /* synthetic */ String lambda$getBase$0(String rec$, Object xva$0) {
            return "dc=%s".formatted(xva$0);
        }
    }
}

