/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.lifecycle;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.boot.testcontainers.lifecycle.BeforeTestcontainerUsedEvent;
import org.springframework.boot.testcontainers.lifecycle.TestcontainersStartup;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.log.LogMessage;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.TestcontainersConfiguration;

@Order(value=0x7FFFFFFF)
class TestcontainersLifecycleBeanPostProcessor
implements DestructionAwareBeanPostProcessor,
ApplicationListener<BeforeTestcontainerUsedEvent> {
    private static final Log logger = LogFactory.getLog(TestcontainersLifecycleBeanPostProcessor.class);
    private final ConfigurableListableBeanFactory beanFactory;
    private final TestcontainersStartup startup;
    private final AtomicReference<Startables> startables = new AtomicReference<Startables>(Startables.UNSTARTED);
    private final AtomicBoolean containersInitialized = new AtomicBoolean();

    TestcontainersLifecycleBeanPostProcessor(ConfigurableListableBeanFactory beanFactory, TestcontainersStartup startup) {
        this.beanFactory = beanFactory;
        this.startup = startup;
    }

    @Deprecated(since="3.4.0", forRemoval=true)
    public void onApplicationEvent(BeforeTestcontainerUsedEvent event) {
        this.initializeContainers();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.beanFactory.isConfigurationFrozen() && !this.isAotProcessingInProgress()) {
            this.initializeContainers();
        }
        if (bean instanceof Startable) {
            Startable startableBean = (Startable)bean;
            if (this.startables.compareAndExchange(Startables.UNSTARTED, Startables.STARTING) == Startables.UNSTARTED) {
                this.initializeStartables(startableBean, beanName);
            } else if (this.startables.get() == Startables.STARTED) {
                logger.trace((Object)LogMessage.format((String)"Starting container %s", (Object)beanName));
                startableBean.start();
            }
        }
        return bean;
    }

    private boolean isAotProcessingInProgress() {
        return Boolean.getBoolean("spring.aot.processing");
    }

    private void initializeStartables(Startable startableBean, String startableBeanName) {
        logger.trace((Object)LogMessage.format((String)"Initializing startables", (Object[])new Object[0]));
        ArrayList<String> beanNames = new ArrayList<String>(this.getBeanNames(Startable.class));
        beanNames.remove(startableBeanName);
        List<Object> beans = this.getBeans(beanNames);
        if (beans == null) {
            logger.trace((Object)LogMessage.format((String)"Failed to obtain startables %s", beanNames));
            this.startables.set(Startables.UNSTARTED);
            return;
        }
        beanNames.add(startableBeanName);
        beans.add(startableBean);
        logger.trace((Object)LogMessage.format((String)"Starting startables %s", beanNames));
        this.start(beans);
        this.startables.set(Startables.STARTED);
        if (!beanNames.isEmpty()) {
            logger.debug((Object)LogMessage.format((String)"Initialized and started startable beans '%s'", beanNames));
        }
    }

    private void start(List<Object> beans) {
        Set startables = beans.stream().filter(Startable.class::isInstance).map(Startable.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
        this.startup.start(startables);
    }

    private void initializeContainers() {
        if (this.containersInitialized.compareAndSet(false, true)) {
            logger.trace((Object)"Initializing containers");
            List<String> beanNames = this.getBeanNames(ContainerState.class);
            List<Object> beans = this.getBeans(beanNames);
            if (beans != null) {
                logger.trace((Object)LogMessage.format((String)"Initialized containers %s", beanNames));
            } else {
                logger.trace((Object)LogMessage.format((String)"Failed to initialize containers %s", beanNames));
                this.containersInitialized.set(false);
            }
        }
    }

    private List<String> getBeanNames(Class<?> type) {
        return List.of(this.beanFactory.getBeanNamesForType(type, true, false));
    }

    private List<Object> getBeans(List<String> beanNames) {
        ArrayList<Object> beans = new ArrayList<Object>(beanNames.size());
        for (String beanName : beanNames) {
            try {
                beans.add(this.beanFactory.getBean(beanName));
            }
            catch (BeanCreationException ex) {
                if (ex.contains(BeanCurrentlyInCreationException.class)) {
                    return null;
                }
                throw ex;
            }
        }
        return beans;
    }

    public boolean requiresDestruction(Object bean) {
        return bean instanceof Startable;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (bean instanceof Startable) {
            Startable startable = (Startable)bean;
            if (!this.isDestroyedByFramework(beanName) && !this.isReusedContainer(bean)) {
                startable.close();
            }
        }
    }

    private boolean isDestroyedByFramework(String beanName) {
        try {
            BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
            String destroyMethodName = beanDefinition.getDestroyMethodName();
            return !"".equals(destroyMethodName);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }

    private boolean isReusedContainer(Object bean) {
        GenericContainer container;
        return bean instanceof GenericContainer && (container = (GenericContainer)bean).isShouldBeReused() && TestcontainersConfiguration.getInstance().environmentSupportsReuse();
    }

    static enum Startables {
        UNSTARTED,
        STARTING,
        STARTED;

    }
}

