/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.otlp;

import org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpTracingConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Container;

class OpenTelemetryTracingContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, OtlpTracingConnectionDetails> {
    OpenTelemetryTracingContainerConnectionDetailsFactory() {
        super("otel/opentelemetry-collector-contrib", "org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpAutoConfiguration");
    }

    @Override
    protected OtlpTracingConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new OpenTelemetryTracingContainerConnectionDetails(source);
    }

    private static final class OpenTelemetryTracingContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements OtlpTracingConnectionDetails {
        private OpenTelemetryTracingContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        public String getUrl() {
            return "http://%s:%d/v1/traces".formatted(this.getContainer().getHost(), this.getContainer().getMappedPort(4318));
        }
    }
}

