/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.assertj;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Supplier;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.context.ApplicationContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class AssertProviderApplicationContextInvocationHandler
implements InvocationHandler {
    private final Class<?> applicationContextType;
    private final ApplicationContext applicationContext;
    private final RuntimeException startupFailure;

    AssertProviderApplicationContextInvocationHandler(Class<?> applicationContextType, Supplier<?> contextSupplier) {
        this.applicationContextType = applicationContextType;
        Object contextOrStartupFailure = this.getContextOrStartupFailure(contextSupplier);
        if (contextOrStartupFailure instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)contextOrStartupFailure;
            this.applicationContext = null;
            this.startupFailure = runtimeException;
        } else {
            this.applicationContext = (ApplicationContext)contextOrStartupFailure;
            this.startupFailure = null;
        }
    }

    private Object getContextOrStartupFailure(Supplier<?> contextSupplier) {
        try {
            return contextSupplier.get();
        }
        catch (RuntimeException ex) {
            return ex;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isToString(method)) {
            return this.toString();
        }
        if (this.isGetSourceContext(method)) {
            return this.getSourceContext(args);
        }
        if (this.isGetStartupFailure(method)) {
            return this.getStartupFailure();
        }
        if (this.isAssertThat(method)) {
            return this.getAssertThat(proxy);
        }
        if (this.isCloseMethod(method)) {
            return this.invokeClose();
        }
        return this.invokeApplicationContextMethod(method, args);
    }

    private boolean isToString(Method method) {
        return "toString".equals(method.getName()) && method.getParameterCount() == 0;
    }

    public String toString() {
        if (this.startupFailure != null) {
            return "Unstarted application context " + this.applicationContextType.getName() + "[startupFailure=" + this.startupFailure.getClass().getName() + "]";
        }
        ToStringCreator builder = new ToStringCreator((Object)this.applicationContext).append("id", (Object)this.applicationContext.getId()).append("applicationName", (Object)this.applicationContext.getApplicationName()).append("beanDefinitionCount", this.applicationContext.getBeanDefinitionCount());
        return "Started application " + builder;
    }

    private boolean isGetSourceContext(Method method) {
        return "getSourceApplicationContext".equals(method.getName()) && (method.getParameterCount() == 0 || Arrays.equals(new Class[]{Class.class}, method.getParameterTypes()));
    }

    private Object getSourceContext(Object[] args) {
        ApplicationContext context = this.getStartedApplicationContext();
        if (!ObjectUtils.isEmpty((Object[])args)) {
            Assert.isInstanceOf((Class)((Class)args[0]), (Object)context);
        }
        return context;
    }

    private boolean isGetStartupFailure(Method method) {
        return "getStartupFailure".equals(method.getName()) && method.getParameterCount() == 0;
    }

    private Object getStartupFailure() {
        return this.startupFailure;
    }

    private boolean isAssertThat(Method method) {
        return "assertThat".equals(method.getName()) && method.getParameterCount() == 0;
    }

    private Object getAssertThat(Object proxy) {
        return new ApplicationContextAssert<ApplicationContext>((ApplicationContext)proxy, this.startupFailure);
    }

    private boolean isCloseMethod(Method method) {
        return "close".equals(method.getName()) && method.getParameterCount() == 0;
    }

    private Object invokeClose() throws IOException {
        ApplicationContext applicationContext = this.applicationContext;
        if (applicationContext instanceof Closeable) {
            Closeable closeable = (Closeable)applicationContext;
            closeable.close();
        }
        return null;
    }

    private Object invokeApplicationContextMethod(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)this.getStartedApplicationContext(), args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    private ApplicationContext getStartedApplicationContext() {
        if (this.startupFailure != null) {
            throw new IllegalStateException(this + " failed to start", this.startupFailure);
        }
        return this.applicationContext;
    }
}

