/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.filter;

import java.io.IOException;
import org.springframework.boot.context.TypeExcludeFilter;
import org.springframework.boot.test.context.TestComponent;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;

class TestTypeExcludeFilter
extends TypeExcludeFilter {
    private static final String TEST_ANNOTATION = "org.junit.Test";

    TestTypeExcludeFilter() {
    }

    public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        if (this.isTestConfiguration(metadataReader)) {
            return true;
        }
        if (this.isTestClass(metadataReader)) {
            return true;
        }
        String enclosing = metadataReader.getClassMetadata().getEnclosingClassName();
        if (enclosing != null) {
            try {
                if (this.match(metadataReaderFactory.getMetadataReader(enclosing), metadataReaderFactory)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isTestConfiguration(MetadataReader metadataReader) {
        return metadataReader.getAnnotationMetadata().isAnnotated(TestComponent.class.getName());
    }

    private boolean isTestClass(MetadataReader metadataReader) {
        return !metadataReader.getAnnotationMetadata().getAnnotatedMethods(TEST_ANNOTATION).isEmpty();
    }
}

