/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.graphql.tester;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.GraphQL;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.graphql.autoconfigure.GraphQlAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.test.tester.ExecutionGraphQlServiceTester;
import org.springframework.graphql.test.tester.GraphQlTester;
import org.springframework.http.MediaType;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;

@AutoConfiguration(after={GraphQlAutoConfiguration.class})
@ConditionalOnClass(value={GraphQL.class, GraphQlTester.class})
public final class GraphQlTesterAutoConfiguration {
    private static final MediaType APPLICATION_GRAPHQL = new MediaType("application", "graphql+json");

    @Bean
    @ConditionalOnBean(value={ExecutionGraphQlService.class})
    @ConditionalOnMissingBean
    ExecutionGraphQlServiceTester graphQlTester(ExecutionGraphQlService graphQlService, ObjectProvider<ObjectMapper> objectMapperProvider) {
        ExecutionGraphQlServiceTester.Builder builder = ExecutionGraphQlServiceTester.builder((ExecutionGraphQlService)graphQlService);
        objectMapperProvider.ifAvailable(objectMapper -> {
            builder.encoder((Encoder)new Jackson2JsonEncoder(objectMapper, new MimeType[]{MediaType.APPLICATION_GRAPHQL_RESPONSE, MediaType.APPLICATION_JSON, APPLICATION_GRAPHQL}));
            builder.decoder((Decoder)new Jackson2JsonDecoder(objectMapper, new MimeType[]{MediaType.APPLICATION_JSON}));
        });
        return builder.build();
    }
}

