/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.session.autoconfigure;

import java.time.Duration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.session.autoconfigure.DefaultCookieSerializerCustomizer;
import org.springframework.boot.session.autoconfigure.SessionProperties;
import org.springframework.boot.session.autoconfigure.SessionRepositoryFilterConfiguration;
import org.springframework.boot.web.server.Cookie;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.session.Session;
import org.springframework.session.security.web.authentication.SpringSessionRememberMeServices;
import org.springframework.session.web.http.CookieHttpSessionIdResolver;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.session.web.http.HttpSessionIdResolver;

@AutoConfiguration
@ConditionalOnClass(value={Session.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={ServerProperties.class, SessionProperties.class})
public final class SessionAutoConfiguration {

    static class DefaultCookieSerializerCondition
    extends AnyNestedCondition {
        DefaultCookieSerializerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={CookieHttpSessionIdResolver.class})
        @ConditionalOnMissingBean(value={CookieSerializer.class})
        static class CookieHttpSessionIdResolverAvailable {
            CookieHttpSessionIdResolverAvailable() {
            }
        }

        @ConditionalOnMissingBean(value={HttpSessionIdResolver.class, CookieSerializer.class})
        static class NoComponentsAvailable {
            NoComponentsAvailable() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Import(value={SessionRepositoryFilterConfiguration.class})
    static class ServletSessionConfiguration {
        ServletSessionConfiguration() {
        }

        @Bean
        @Conditional(value={DefaultCookieSerializerCondition.class})
        DefaultCookieSerializer cookieSerializer(ServerProperties serverProperties, ObjectProvider<DefaultCookieSerializerCustomizer> cookieSerializerCustomizers) {
            Cookie cookie = serverProperties.getServlet().getSession().getCookie();
            DefaultCookieSerializer cookieSerializer = new DefaultCookieSerializer();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(() -> ((Cookie)cookie).getName()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setCookieName(arg_0));
            map.from(() -> ((Cookie)cookie).getDomain()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setDomainName(arg_0));
            map.from(() -> ((Cookie)cookie).getPath()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setCookiePath(arg_0));
            map.from(() -> ((Cookie)cookie).getHttpOnly()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setUseHttpOnlyCookie(arg_0));
            map.from(() -> ((Cookie)cookie).getSecure()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setUseSecureCookie(arg_0));
            map.from(() -> ((Cookie)cookie).getMaxAge()).asInt(Duration::getSeconds).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setCookieMaxAge(arg_0));
            this.setSameSite(map, cookie, cookieSerializer);
            map.from(() -> ((Cookie)cookie).getPartitioned()).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setPartitioned(arg_0));
            cookieSerializerCustomizers.orderedStream().forEach(customizer -> customizer.customize(cookieSerializer));
            return cookieSerializer;
        }

        private void setSameSite(PropertyMapper map, Cookie cookie, DefaultCookieSerializer cookieSerializer) {
            map.from(() -> ((Cookie)cookie).getSameSite()).as(Cookie.SameSite::attributeValue).to(arg_0 -> ((DefaultCookieSerializer)cookieSerializer).setSameSite(arg_0));
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={RememberMeServices.class})
        static class RememberMeServicesConfiguration {
            RememberMeServicesConfiguration() {
            }

            @Bean
            DefaultCookieSerializerCustomizer rememberMeServicesCookieSerializerCustomizer() {
                return cookieSerializer -> cookieSerializer.setRememberMeRequestAttribute(SpringSessionRememberMeServices.REMEMBER_ME_LOGIN_ATTR);
            }
        }
    }
}

