/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.saml2.autoconfigure;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;

@ConfigurationProperties(value="spring.security.saml2.relyingparty")
public class Saml2RelyingPartyProperties {
    private final Map<String, Registration> registration = new LinkedHashMap<String, Registration>();

    public Map<String, Registration> getRegistration() {
        return this.registration;
    }

    public static class Singlelogout {
        private @Nullable String url;
        private @Nullable String responseUrl;
        private @Nullable Saml2MessageBinding binding;

        public @Nullable String getUrl() {
            return this.url;
        }

        public void setUrl(@Nullable String url) {
            this.url = url;
        }

        public @Nullable String getResponseUrl() {
            return this.responseUrl;
        }

        public void setResponseUrl(@Nullable String responseUrl) {
            this.responseUrl = responseUrl;
        }

        public @Nullable Saml2MessageBinding getBinding() {
            return this.binding;
        }

        public void setBinding(@Nullable Saml2MessageBinding binding) {
            this.binding = binding;
        }
    }

    public static class AssertingParty {
        private @Nullable String entityId;
        private @Nullable String metadataUri;
        private final Singlesignon singlesignon = new Singlesignon();
        private final Verification verification = new Verification();
        private final Singlelogout singlelogout = new Singlelogout();

        public @Nullable String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(@Nullable String entityId) {
            this.entityId = entityId;
        }

        public @Nullable String getMetadataUri() {
            return this.metadataUri;
        }

        public void setMetadataUri(@Nullable String metadataUri) {
            this.metadataUri = metadataUri;
        }

        public Singlesignon getSinglesignon() {
            return this.singlesignon;
        }

        public Verification getVerification() {
            return this.verification;
        }

        public Singlelogout getSinglelogout() {
            return this.singlelogout;
        }

        public static class Singlesignon {
            private @Nullable String url;
            private @Nullable Saml2MessageBinding binding;
            private @Nullable Boolean signRequest;

            public @Nullable String getUrl() {
                return this.url;
            }

            public void setUrl(@Nullable String url) {
                this.url = url;
            }

            public @Nullable Saml2MessageBinding getBinding() {
                return this.binding;
            }

            public void setBinding(@Nullable Saml2MessageBinding binding) {
                this.binding = binding;
            }

            public @Nullable Boolean getSignRequest() {
                return this.signRequest;
            }

            public void setSignRequest(@Nullable Boolean signRequest) {
                this.signRequest = signRequest;
            }
        }

        public static class Verification {
            private List<Credential> credentials = new ArrayList<Credential>();

            public List<Credential> getCredentials() {
                return this.credentials;
            }

            public void setCredentials(List<Credential> credentials) {
                this.credentials = credentials;
            }

            public static class Credential {
                private @Nullable Resource certificate;

                public @Nullable Resource getCertificateLocation() {
                    return this.certificate;
                }

                public void setCertificateLocation(@Nullable Resource certificate) {
                    this.certificate = certificate;
                }
            }
        }
    }

    public static class Decryption {
        private List<Credential> credentials = new ArrayList<Credential>();

        public List<Credential> getCredentials() {
            return this.credentials;
        }

        public void setCredentials(List<Credential> credentials) {
            this.credentials = credentials;
        }

        public static class Credential {
            private @Nullable Resource privateKeyLocation;
            private @Nullable Resource certificateLocation;

            public @Nullable Resource getPrivateKeyLocation() {
                return this.privateKeyLocation;
            }

            public void setPrivateKeyLocation(@Nullable Resource privateKey) {
                this.privateKeyLocation = privateKey;
            }

            public @Nullable Resource getCertificateLocation() {
                return this.certificateLocation;
            }

            public void setCertificateLocation(@Nullable Resource certificate) {
                this.certificateLocation = certificate;
            }
        }
    }

    public static class Registration {
        private String entityId = "{baseUrl}/saml2/service-provider-metadata/{registrationId}";
        private final Acs acs = new Acs();
        private final Signing signing = new Signing();
        private final Decryption decryption = new Decryption();
        private final Singlelogout singlelogout = new Singlelogout();
        private final AssertingParty assertingparty = new AssertingParty();
        private @Nullable String nameIdFormat;

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public Acs getAcs() {
            return this.acs;
        }

        public Signing getSigning() {
            return this.signing;
        }

        public Decryption getDecryption() {
            return this.decryption;
        }

        public Singlelogout getSinglelogout() {
            return this.singlelogout;
        }

        public AssertingParty getAssertingparty() {
            return this.assertingparty;
        }

        public @Nullable String getNameIdFormat() {
            return this.nameIdFormat;
        }

        public void setNameIdFormat(@Nullable String nameIdFormat) {
            this.nameIdFormat = nameIdFormat;
        }

        public static class Acs {
            private String location = "{baseUrl}/login/saml2/sso/{registrationId}";
            private Saml2MessageBinding binding = Saml2MessageBinding.POST;

            public String getLocation() {
                return this.location;
            }

            public void setLocation(String location) {
                this.location = location;
            }

            public Saml2MessageBinding getBinding() {
                return this.binding;
            }

            public void setBinding(Saml2MessageBinding binding) {
                this.binding = binding;
            }
        }

        public static class Signing {
            private List<Credential> credentials = new ArrayList<Credential>();

            public List<Credential> getCredentials() {
                return this.credentials;
            }

            public void setCredentials(List<Credential> credentials) {
                this.credentials = credentials;
            }

            public static class Credential {
                private @Nullable Resource privateKeyLocation;
                private @Nullable Resource certificateLocation;

                public @Nullable Resource getPrivateKeyLocation() {
                    return this.privateKeyLocation;
                }

                public void setPrivateKeyLocation(@Nullable Resource privateKey) {
                    this.privateKeyLocation = privateKey;
                }

                public @Nullable Resource getCertificateLocation() {
                    return this.certificateLocation;
                }

                public void setCertificateLocation(@Nullable Resource certificate) {
                    this.certificateLocation = certificate;
                }
            }
        }
    }
}

