/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.saml2.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.security.autoconfigure.ConditionalOnDefaultWebSecurity;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.web.SecurityFilterChain;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDefaultWebSecurity
@ConditionalOnBean(value={RelyingPartyRegistrationRepository.class})
class Saml2LoginConfiguration {
    Saml2LoginConfiguration() {
    }

    @Bean
    SecurityFilterChain samlSecurityFilterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated());
        http.saml2Login(Customizer.withDefaults());
        http.saml2Logout(Customizer.withDefaults());
        return (SecurityFilterChain)http.build();
    }
}

