/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.oauth2.server.resource.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

class KeyValueCondition
extends SpringBootCondition {
    KeyValueCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Public Key Value Condition", (Object[])new Object[0]);
        Environment environment = context.getEnvironment();
        String publicKeyLocation = environment.getProperty("spring.security.oauth2.resourceserver.jwt.public-key-location");
        if (!StringUtils.hasText((String)publicKeyLocation)) {
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("public-key-location property").atAll());
        }
        String jwkSetUri = environment.getProperty("spring.security.oauth2.resourceserver.jwt.jwk-set-uri");
        if (StringUtils.hasText((String)jwkSetUri)) {
            return ConditionOutcome.noMatch((ConditionMessage)message.found("jwk-set-uri property").items(new Object[]{jwkSetUri}));
        }
        String issuerUri = environment.getProperty("spring.security.oauth2.resourceserver.jwt.issuer-uri");
        if (StringUtils.hasText((String)issuerUri)) {
            return ConditionOutcome.noMatch((ConditionMessage)message.found("issuer-uri property").items(new Object[]{issuerUri}));
        }
        return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"public key location property"));
    }
}

