/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.rsocket.netty;

import io.rsocket.transport.netty.server.CloseableChannel;
import java.net.InetSocketAddress;
import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.rsocket.server.RSocketServer;
import org.springframework.boot.rsocket.server.RSocketServerException;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class NettyRSocketServer
implements RSocketServer {
    private static final Log logger = LogFactory.getLog(NettyRSocketServer.class);
    private final Mono<CloseableChannel> starter;
    private final @Nullable Duration lifecycleTimeout;
    private @Nullable CloseableChannel channel;

    public NettyRSocketServer(Mono<CloseableChannel> starter, @Nullable Duration lifecycleTimeout) {
        Assert.notNull(starter, (String)"'starter' must not be null");
        this.starter = starter;
        this.lifecycleTimeout = lifecycleTimeout;
    }

    @Override
    public @Nullable InetSocketAddress address() {
        if (this.channel != null) {
            return this.channel.address();
        }
        return null;
    }

    @Override
    public void start() throws RSocketServerException {
        this.channel = this.block(this.starter, this.lifecycleTimeout);
        InetSocketAddress address = this.address();
        Assert.state((address != null ? 1 : 0) != 0, (String)"'address' must not be null");
        logger.info((Object)("Netty RSocket started on port " + address.getPort()));
        this.startDaemonAwaitThread(this.channel);
    }

    private void startDaemonAwaitThread(@Nullable CloseableChannel channel) {
        if (channel == null) {
            return;
        }
        Thread awaitThread = new Thread(() -> channel.onClose().block(), "rsocket");
        awaitThread.setContextClassLoader(this.getClass().getClassLoader());
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    @Override
    public void stop() throws RSocketServerException {
        if (this.channel != null) {
            this.channel.dispose();
            this.channel = null;
        }
    }

    private <T> @Nullable T block(Mono<T> mono, @Nullable Duration timeout) {
        return (T)(timeout != null ? mono.block(timeout) : mono.block());
    }
}

