/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.rsocket.autoconfigure;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import io.netty.buffer.PooledByteBufAllocator;
import io.rsocket.RSocket;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.rsocket.messaging.RSocketStrategiesCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.MediaType;
import org.springframework.http.codec.cbor.Jackson2CborDecoder;
import org.springframework.http.codec.cbor.Jackson2CborEncoder;
import org.springframework.http.codec.cbor.JacksonCborDecoder;
import org.springframework.http.codec.cbor.JacksonCborEncoder;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.json.JacksonJsonDecoder;
import org.springframework.http.codec.json.JacksonJsonEncoder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.RouteMatcher;
import org.springframework.web.util.pattern.PathPatternRouteMatcher;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.dataformat.cbor.CBORMapper;

@AutoConfiguration(afterName={"org.springframework.boot.jackson.autoconfigure.JacksonAutoConfiguration", "org.springframework.boot.jackson2.autoconfigure.Jackson2AutoConfiguration"})
@ConditionalOnClass(value={RSocket.class, RSocketStrategies.class, PooledByteBufAllocator.class})
public final class RSocketStrategiesAutoConfiguration {
    private static final String PATHPATTERN_ROUTEMATCHER_CLASS = "org.springframework.web.util.pattern.PathPatternRouteMatcher";

    @Bean
    @ConditionalOnMissingBean
    RSocketStrategies rSocketStrategies(ObjectProvider<RSocketStrategiesCustomizer> customizers) {
        RSocketStrategies.Builder builder = RSocketStrategies.builder();
        if (ClassUtils.isPresent((String)PATHPATTERN_ROUTEMATCHER_CLASS, null)) {
            builder.routeMatcher((RouteMatcher)new PathPatternRouteMatcher());
        }
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    static class NoJacksonOrJackson2Preferred
    extends AnyNestedCondition {
        NoJacksonOrJackson2Preferred() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(name={"spring.rsocket.preferred-mapper"}, havingValue="jackson2")
        static class Jackson2Preferred {
            Jackson2Preferred() {
            }
        }

        @ConditionalOnMissingClass(value={"tools.jackson.databind.json.JsonMapper"})
        static class NoJackson {
            NoJackson() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={NoJacksonOrJackson2Preferred.class})
    @Deprecated(since="4.0.0", forRemoval=true)
    static class Jackson2StrategyConfiguration {
        Jackson2StrategyConfiguration() {
        }

        @ConditionalOnClass(value={ObjectMapper.class})
        static class Jackson2JsonStrategyConfiguration {
            private static final MediaType[] SUPPORTED_TYPES = new MediaType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")};

            Jackson2JsonStrategyConfiguration() {
            }

            @Bean
            @Order(value=1)
            @ConditionalOnBean(value={ObjectMapper.class})
            RSocketStrategiesCustomizer jackson2JsonRSocketStrategyCustomizer(ObjectMapper objectMapper) {
                return strategy -> {
                    strategy.decoder(new Decoder[]{new Jackson2JsonDecoder(objectMapper, (MimeType[])SUPPORTED_TYPES)});
                    strategy.encoder(new Encoder[]{new Jackson2JsonEncoder(objectMapper, (MimeType[])SUPPORTED_TYPES)});
                };
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={ObjectMapper.class, CBORFactory.class})
        static class Jackson2CborStrategyConfiguration {
            private static final MediaType[] SUPPORTED_TYPES = new MediaType[]{MediaType.APPLICATION_CBOR};

            Jackson2CborStrategyConfiguration() {
            }

            @Bean
            @Order(value=0)
            @ConditionalOnBean(value={Jackson2ObjectMapperBuilder.class})
            RSocketStrategiesCustomizer jackson2CborRSocketStrategyCustomizer(Jackson2ObjectMapperBuilder builder) {
                return strategy -> {
                    ObjectMapper objectMapper = builder.createXmlMapper(false).factory((JsonFactory)new CBORFactory()).build();
                    strategy.decoder(new Decoder[]{new Jackson2CborDecoder(objectMapper, (MimeType[])SUPPORTED_TYPES)});
                    strategy.encoder(new Encoder[]{new Jackson2CborEncoder(objectMapper, (MimeType[])SUPPORTED_TYPES)});
                };
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(name={"spring.rsocket.preferred-mapper"}, havingValue="jackson", matchIfMissing=true)
    static class JacksonStrategyConfiguration {
        JacksonStrategyConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={JsonMapper.class})
        static class JacksonJsonStrategyConfiguration {
            private static final MediaType[] SUPPORTED_TYPES = new MediaType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")};

            JacksonJsonStrategyConfiguration() {
            }

            @Bean
            @Order(value=1)
            @ConditionalOnBean(value={JsonMapper.class})
            RSocketStrategiesCustomizer jacksonJsonRSocketStrategyCustomizer(JsonMapper jsonMapper) {
                return strategy -> {
                    strategy.decoder(new Decoder[]{new JacksonJsonDecoder(jsonMapper, (MimeType[])SUPPORTED_TYPES)});
                    strategy.encoder(new Encoder[]{new JacksonJsonEncoder(jsonMapper, (MimeType[])SUPPORTED_TYPES)});
                };
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={CBORMapper.class})
        @ConditionalOnBean(value={CBORMapper.class})
        static class JacksonCborStrategyConfiguration {
            private static final MediaType[] SUPPORTED_TYPES = new MediaType[]{MediaType.APPLICATION_CBOR};

            JacksonCborStrategyConfiguration() {
            }

            @Bean
            @Order(value=0)
            RSocketStrategiesCustomizer jacksonCborRSocketStrategyCustomizer(CBORMapper cborMapper) {
                return strategy -> {
                    strategy.decoder(new Decoder[]{new JacksonCborDecoder(cborMapper, (MimeType[])SUPPORTED_TYPES)});
                    strategy.encoder(new Encoder[]{new JacksonCborEncoder(cborMapper, (MimeType[])SUPPORTED_TYPES)});
                };
            }
        }
    }
}

