/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient.autoconfigure;

import java.util.Arrays;
import java.util.List;
import org.springframework.boot.http.converter.autoconfigure.ClientHttpMessageConvertersCustomizer;
import org.springframework.boot.restclient.RestClientCustomizer;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClient;

public class HttpMessageConvertersRestClientCustomizer
implements RestClientCustomizer {
    private final List<ClientHttpMessageConvertersCustomizer> customizers;

    public HttpMessageConvertersRestClientCustomizer(ClientHttpMessageConvertersCustomizer ... customizers) {
        this(Arrays.asList(customizers));
    }

    public HttpMessageConvertersRestClientCustomizer(List<ClientHttpMessageConvertersCustomizer> customizers) {
        Assert.notNull(customizers, (String)"customizers must not be null");
        this.customizers = customizers;
    }

    @Override
    public void customize(RestClient.Builder restClientBuilder) {
        restClientBuilder.configureMessageConverters(builder -> this.customizers.forEach(customizer -> customizer.customize(builder)));
    }
}

