/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.autoconfigure;

import io.r2dbc.spi.ConnectionFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.transaction.autoconfigure.TransactionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.r2dbc.connection.R2dbcTransactionManager;
import org.springframework.transaction.ReactiveTransactionManager;

@AutoConfiguration(before={TransactionAutoConfiguration.class})
@ConditionalOnClass(value={R2dbcTransactionManager.class, ReactiveTransactionManager.class})
@ConditionalOnSingleCandidate(value=ConnectionFactory.class)
@AutoConfigureOrder(value=0x7FFFFFFF)
public class R2dbcTransactionManagerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ReactiveTransactionManager.class})
    public R2dbcTransactionManager connectionFactoryTransactionManager(ConnectionFactory connectionFactory) {
        return new R2dbcTransactionManager(connectionFactory);
    }
}

