/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.quartz.autoconfigure;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.jdbc.init.DatabaseInitializationProperties;
import org.springframework.boot.jdbc.init.PropertiesBasedDataSourceScriptDatabaseInitializer;
import org.springframework.boot.quartz.autoconfigure.QuartzJdbcProperties;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.util.ObjectUtils;

public class QuartzDataSourceScriptDatabaseInitializer
extends PropertiesBasedDataSourceScriptDatabaseInitializer<QuartzJdbcProperties> {
    private final @Nullable List<String> commentPrefixes;

    public QuartzDataSourceScriptDatabaseInitializer(DataSource dataSource, QuartzJdbcProperties properties) {
        super(dataSource, (DatabaseInitializationProperties)properties, Map.of(DatabaseDriver.DB2, "db2_v95", DatabaseDriver.MYSQL, "mysql_innodb", DatabaseDriver.MARIADB, "mysql_innodb", DatabaseDriver.POSTGRESQL, "postgres", DatabaseDriver.SQLSERVER, "sqlServer"));
        this.commentPrefixes = properties.getCommentPrefix();
    }

    protected void customize(ResourceDatabasePopulator populator) {
        if (!ObjectUtils.isEmpty(this.commentPrefixes)) {
            populator.setCommentPrefixes(this.commentPrefixes.toArray(new String[0]));
        }
    }
}

