/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.pulsar.autoconfigure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.pulsar.autoconfigure.PulsarContainerFactoryCustomizer;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.pulsar.config.PulsarContainerFactory;

class PulsarContainerFactoryCustomizers {
    private final List<PulsarContainerFactoryCustomizer<?>> customizers;

    PulsarContainerFactoryCustomizers(@Nullable List<? extends PulsarContainerFactoryCustomizer<?>> customizers) {
        this.customizers = customizers != null ? new ArrayList(customizers) : Collections.emptyList();
    }

    <T extends PulsarContainerFactory<?, ?>> T customize(T containerFactory) {
        ((LambdaSafe.Callbacks)LambdaSafe.callbacks(PulsarContainerFactoryCustomizer.class, this.customizers, containerFactory, (Object[])new Object[0]).withLogger(PulsarContainerFactoryCustomizers.class)).invoke(customizer -> customizer.customize(containerFactory));
        return containerFactory;
    }
}

