/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.neo4j.docker.compose;

import java.net.URI;
import org.jspecify.annotations.Nullable;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.neo4j.autoconfigure.Neo4jConnectionDetails;
import org.springframework.boot.neo4j.docker.compose.Neo4jEnvironment;

class Neo4jDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<Neo4jConnectionDetails> {
    Neo4jDockerComposeConnectionDetailsFactory() {
        super("neo4j", new String[0]);
    }

    protected Neo4jConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new Neo4jDockerComposeConnectionDetails(source.getRunningService());
    }

    static class Neo4jDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements Neo4jConnectionDetails {
        private static final int BOLT_PORT = 7687;
        private final @Nullable AuthToken authToken;
        private final URI uri;

        Neo4jDockerComposeConnectionDetails(RunningService service) {
            super(service);
            Neo4jEnvironment neo4jEnvironment = new Neo4jEnvironment(service.env());
            this.authToken = neo4jEnvironment.getAuthToken();
            this.uri = URI.create("neo4j://%s:%d".formatted(service.host(), service.ports().get(7687)));
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public AuthToken getAuthToken() {
            return this.authToken != null ? this.authToken : AuthTokens.none();
        }
    }
}

