/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mustache.autoconfigure;

import com.samskivert.mustache.Mustache;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class MustacheResourceTemplateLoader
implements Mustache.TemplateLoader,
ResourceLoaderAware {
    private String prefix = "";
    private String suffix = "";
    private Charset charset = StandardCharsets.UTF_8;
    private ResourceLoader resourceLoader = new DefaultResourceLoader(null);

    public MustacheResourceTemplateLoader() {
    }

    public MustacheResourceTemplateLoader(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public void setCharset(String charset) {
        this.charset = Charset.forName(charset);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Reader getTemplate(String name) throws Exception {
        return new InputStreamReader(this.resourceLoader.getResource(this.prefix + name + this.suffix).getInputStream(), this.charset);
    }
}

