/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mustache.autoconfigure;

import com.samskivert.mustache.Mustache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.mustache.autoconfigure.MustacheProperties;
import org.springframework.boot.mustache.reactive.view.MustacheViewResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
class MustacheReactiveWebConfiguration {
    MustacheReactiveWebConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBooleanProperty(name={"spring.mustache.enabled"}, matchIfMissing=true)
    MustacheViewResolver mustacheViewResolver(Mustache.Compiler mustacheCompiler, MustacheProperties mustache) {
        MustacheViewResolver resolver = new MustacheViewResolver(mustacheCompiler);
        PropertyMapper map = PropertyMapper.get();
        map.from(mustache::getPrefix).to(arg_0 -> ((MustacheViewResolver)resolver).setPrefix(arg_0));
        map.from(mustache::getSuffix).to(arg_0 -> ((MustacheViewResolver)resolver).setSuffix(arg_0));
        map.from(mustache::getViewNames).to(arg_0 -> ((MustacheViewResolver)resolver).setViewNames(arg_0));
        map.from(mustache::getRequestContextAttribute).to(arg_0 -> ((MustacheViewResolver)resolver).setRequestContextAttribute(arg_0));
        map.from(mustache::getCharsetName).to(resolver::setCharset);
        map.from(mustache.getReactive()::getMediaTypes).to(arg_0 -> ((MustacheViewResolver)resolver).setSupportedMediaTypes(arg_0));
        resolver.setOrder(0x7FFFFFF5);
        return resolver;
    }
}

