/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mongodb.autoconfigure.health;

import com.mongodb.reactivestreams.client.MongoClient;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.health.autoconfigure.contributor.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.boot.mongodb.autoconfigure.MongoReactiveAutoConfiguration;
import org.springframework.boot.mongodb.health.MongoReactiveHealthIndicator;
import org.springframework.context.annotation.Bean;
import reactor.core.publisher.Flux;

@AutoConfiguration(after={MongoReactiveAutoConfiguration.class})
@ConditionalOnClass(value={MongoClient.class, Flux.class, MongoReactiveHealthIndicator.class, ConditionalOnEnabledHealthIndicator.class})
@ConditionalOnBean(value={MongoClient.class})
@ConditionalOnEnabledHealthIndicator(value="mongodb")
public final class MongoReactiveHealthContributorAutoConfiguration
extends CompositeReactiveHealthContributorConfiguration<MongoReactiveHealthIndicator, MongoClient> {
    MongoReactiveHealthContributorAutoConfiguration() {
        super(MongoReactiveHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"mongoHealthIndicator", "mongoHealthContributor"})
    ReactiveHealthContributor mongoHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (ReactiveHealthContributor)this.createContributor(beanFactory, MongoClient.class);
    }
}

