/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mongodb.autoconfigure.health;

import com.mongodb.client.MongoClient;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.health.autoconfigure.contributor.CompositeHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.mongodb.autoconfigure.MongoAutoConfiguration;
import org.springframework.boot.mongodb.autoconfigure.health.MongoReactiveHealthContributorAutoConfiguration;
import org.springframework.boot.mongodb.health.MongoHealthIndicator;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={MongoReactiveHealthContributorAutoConfiguration.class, MongoAutoConfiguration.class})
@ConditionalOnClass(value={MongoClient.class, MongoHealthIndicator.class, ConditionalOnEnabledHealthIndicator.class})
@ConditionalOnBean(value={MongoClient.class})
@ConditionalOnEnabledHealthIndicator(value="mongodb")
public final class MongoHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<MongoHealthIndicator, MongoClient> {
    MongoHealthContributorAutoConfiguration() {
        super(MongoHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"mongoHealthIndicator", "mongoHealthContributor"})
    HealthContributor mongoHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (HealthContributor)this.createContributor(beanFactory, MongoClient.class);
    }
}

