/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mongodb.autoconfigure;

import com.mongodb.ConnectionString;
import java.util.List;
import org.bson.UuidRepresentation;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.data.mongodb")
public class MongoProperties {
    public static final int DEFAULT_PORT = 27017;
    public static final String DEFAULT_URI = "mongodb://localhost/test";
    private String protocol = "mongodb";
    private @Nullable String host;
    private @Nullable Integer port;
    private @Nullable List<String> additionalHosts;
    private @Nullable String uri;
    private @Nullable String database;
    private @Nullable String authenticationDatabase;
    private final Gridfs gridfs = new Gridfs();
    private @Nullable String username;
    private char @Nullable [] password;
    private @Nullable String replicaSetName;
    private @Nullable Class<?> fieldNamingStrategy;
    private UuidRepresentation uuidRepresentation = UuidRepresentation.STANDARD;
    private final Ssl ssl = new Ssl();
    private @Nullable Boolean autoIndexCreation;

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public @Nullable String getHost() {
        return this.host;
    }

    public void setHost(@Nullable String host) {
        this.host = host;
    }

    public @Nullable String getDatabase() {
        return this.database;
    }

    public void setDatabase(@Nullable String database) {
        this.database = database;
    }

    public @Nullable String getAuthenticationDatabase() {
        return this.authenticationDatabase;
    }

    public void setAuthenticationDatabase(@Nullable String authenticationDatabase) {
        this.authenticationDatabase = authenticationDatabase;
    }

    public @Nullable String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public char @Nullable [] getPassword() {
        return this.password;
    }

    public void setPassword(char @Nullable [] password) {
        this.password = password;
    }

    public @Nullable String getReplicaSetName() {
        return this.replicaSetName;
    }

    public void setReplicaSetName(@Nullable String replicaSetName) {
        this.replicaSetName = replicaSetName;
    }

    public @Nullable Class<?> getFieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    public void setFieldNamingStrategy(@Nullable Class<?> fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy;
    }

    public UuidRepresentation getUuidRepresentation() {
        return this.uuidRepresentation;
    }

    public void setUuidRepresentation(UuidRepresentation uuidRepresentation) {
        this.uuidRepresentation = uuidRepresentation;
    }

    public @Nullable String getUri() {
        return this.uri;
    }

    public String determineUri() {
        return this.uri != null ? this.uri : DEFAULT_URI;
    }

    public void setUri(@Nullable String uri) {
        this.uri = uri;
    }

    public @Nullable Integer getPort() {
        return this.port;
    }

    public void setPort(@Nullable Integer port) {
        this.port = port;
    }

    public Gridfs getGridfs() {
        return this.gridfs;
    }

    public @Nullable String getMongoClientDatabase() {
        if (this.database != null) {
            return this.database;
        }
        return new ConnectionString(this.determineUri()).getDatabase();
    }

    public @Nullable Boolean isAutoIndexCreation() {
        return this.autoIndexCreation;
    }

    public void setAutoIndexCreation(@Nullable Boolean autoIndexCreation) {
        this.autoIndexCreation = autoIndexCreation;
    }

    public @Nullable List<String> getAdditionalHosts() {
        return this.additionalHosts;
    }

    public void setAdditionalHosts(@Nullable List<String> additionalHosts) {
        this.additionalHosts = additionalHosts;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public static class Gridfs {
        private @Nullable String database;
        private @Nullable String bucket;

        public @Nullable String getDatabase() {
            return this.database;
        }

        public void setDatabase(@Nullable String database) {
            this.database = database;
        }

        public @Nullable String getBucket() {
            return this.bucket;
        }

        public void setBucket(@Nullable String bucket) {
            this.bucket = bucket;
        }
    }

    public static class Ssl {
        private @Nullable Boolean enabled;
        private @Nullable String bundle;

        public boolean isEnabled() {
            return this.enabled != null ? this.enabled : this.bundle != null;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public @Nullable String getBundle() {
            return this.bundle;
        }

        public void setBundle(@Nullable String bundle) {
            this.bundle = bundle;
        }
    }
}

