/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.tracing.autoconfigure;

import io.micrometer.common.annotation.ValueExpressionResolver;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.annotation.DefaultNewSpanParser;
import io.micrometer.tracing.annotation.ImperativeMethodInvocationProcessor;
import io.micrometer.tracing.annotation.MethodInvocationProcessor;
import io.micrometer.tracing.annotation.NewSpanParser;
import io.micrometer.tracing.annotation.SpanAspect;
import io.micrometer.tracing.annotation.SpanTagAnnotationHandler;
import io.micrometer.tracing.handler.DefaultTracingObservationHandler;
import io.micrometer.tracing.handler.PropagatingReceiverTracingObservationHandler;
import io.micrometer.tracing.handler.PropagatingSenderTracingObservationHandler;
import io.micrometer.tracing.handler.TracingObservationHandler;
import io.micrometer.tracing.propagation.Propagator;
import org.aspectj.weaver.Advice;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationAutoConfiguration;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationHandlerGroup;
import org.springframework.boot.micrometer.tracing.autoconfigure.TracingAndMeterObservationHandlerGroup;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.ClassUtils;

@AutoConfiguration(after={ObservationAutoConfiguration.class})
@ConditionalOnBean(value={Tracer.class})
public final class MicrometerTracingAutoConfiguration {
    public static final int DEFAULT_TRACING_OBSERVATION_HANDLER_ORDER = 2147482647;
    public static final int RECEIVER_TRACING_OBSERVATION_HANDLER_ORDER = 1000;
    public static final int SENDER_TRACING_OBSERVATION_HANDLER_ORDER = 2000;

    @Bean
    ObservationHandlerGroup tracingObservationHandlerGroup(Tracer tracer) {
        return ClassUtils.isPresent((String)"io.micrometer.core.instrument.MeterRegistry", null) ? new TracingAndMeterObservationHandlerGroup(tracer) : ObservationHandlerGroup.of(TracingObservationHandler.class);
    }

    @Bean
    @ConditionalOnMissingBean
    @Order(value=2147482647)
    DefaultTracingObservationHandler defaultTracingObservationHandler(Tracer tracer) {
        return new DefaultTracingObservationHandler(tracer);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={Propagator.class})
    @Order(value=2000)
    PropagatingSenderTracingObservationHandler<?> propagatingSenderTracingObservationHandler(Tracer tracer, Propagator propagator) {
        return new PropagatingSenderTracingObservationHandler(tracer, propagator);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={Propagator.class})
    @Order(value=1000)
    PropagatingReceiverTracingObservationHandler<?> propagatingReceiverTracingObservationHandler(Tracer tracer, Propagator propagator) {
        return new PropagatingReceiverTracingObservationHandler(tracer, propagator);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Advice.class})
    @ConditionalOnBooleanProperty(value={"management.observations.annotations.enabled"})
    static class SpanAspectConfiguration {
        SpanAspectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={NewSpanParser.class})
        DefaultNewSpanParser newSpanParser() {
            return new DefaultNewSpanParser();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={ValueExpressionResolver.class})
        SpanTagAnnotationHandler spanTagAnnotationHandler(BeanFactory beanFactory, ValueExpressionResolver valueExpressionResolver) {
            return new SpanTagAnnotationHandler(arg_0 -> ((BeanFactory)beanFactory).getBean(arg_0), ignored -> valueExpressionResolver);
        }

        @Bean
        @ConditionalOnMissingBean(value={MethodInvocationProcessor.class})
        ImperativeMethodInvocationProcessor imperativeMethodInvocationProcessor(NewSpanParser newSpanParser, Tracer tracer, ObjectProvider<SpanTagAnnotationHandler> spanTagAnnotationHandler) {
            return new ImperativeMethodInvocationProcessor(newSpanParser, tracer, (SpanTagAnnotationHandler)spanTagAnnotationHandler.getIfAvailable());
        }

        @Bean
        @ConditionalOnMissingBean
        SpanAspect spanAspect(MethodInvocationProcessor methodInvocationProcessor) {
            return new SpanAspect(methodInvocationProcessor);
        }
    }
}

