/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.tracing.autoconfigure;

import brave.baggage.BaggagePropagation;
import brave.baggage.BaggagePropagationConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class LocalBaggageFields {
    private final List<String> fields;

    LocalBaggageFields(List<String> fields) {
        Assert.notNull(fields, (String)"'fields' must not be null");
        this.fields = fields;
    }

    List<String> asList() {
        return Collections.unmodifiableList(this.fields);
    }

    static LocalBaggageFields extractFrom(BaggagePropagation.FactoryBuilder builder) {
        ArrayList<String> localFields = new ArrayList<String>();
        for (BaggagePropagationConfig config : builder.configs()) {
            BaggagePropagationConfig.SingleBaggageField field;
            if (!(config instanceof BaggagePropagationConfig.SingleBaggageField) || !CollectionUtils.isEmpty((Collection)(field = (BaggagePropagationConfig.SingleBaggageField)config).keyNames())) continue;
            localFields.add(field.field().name());
        }
        return new LocalBaggageFields(localFields);
    }

    static LocalBaggageFields empty() {
        return new LocalBaggageFields(Collections.emptyList());
    }
}

