/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure.jvm;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmCompilationMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmInfoMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.jvm.convention.JvmClassLoadingMeterConventions;
import io.micrometer.core.instrument.binder.jvm.convention.JvmMemoryMeterConventions;
import io.micrometer.core.instrument.binder.jvm.convention.JvmThreadMeterConventions;
import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.util.ClassUtils;

@AutoConfiguration(after={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnClass(value={MeterRegistry.class})
@ConditionalOnBean(value={MeterRegistry.class})
public final class JvmMetricsAutoConfiguration {
    private static final String VIRTUAL_THREAD_METRICS_CLASS = "io.micrometer.java21.instrument.binder.jdk.VirtualThreadMetrics";

    @Bean
    @ConditionalOnMissingBean
    JvmGcMetrics jvmGcMetrics() {
        return new JvmGcMetrics();
    }

    @Bean
    @ConditionalOnMissingBean
    JvmHeapPressureMetrics jvmHeapPressureMetrics() {
        return new JvmHeapPressureMetrics();
    }

    @Bean
    @ConditionalOnMissingBean
    JvmMemoryMetrics jvmMemoryMetrics(ObjectProvider<JvmMemoryMeterConventions> jvmMemoryMeterConventions) {
        JvmMemoryMeterConventions conventions = (JvmMemoryMeterConventions)jvmMemoryMeterConventions.getIfAvailable();
        return conventions != null ? new JvmMemoryMetrics(Collections.emptyList(), conventions) : new JvmMemoryMetrics();
    }

    @Bean
    @ConditionalOnMissingBean
    JvmThreadMetrics jvmThreadMetrics(ObjectProvider<JvmThreadMeterConventions> jvmThreadMeterConventions) {
        JvmThreadMeterConventions conventions = (JvmThreadMeterConventions)jvmThreadMeterConventions.getIfAvailable();
        return conventions != null ? new JvmThreadMetrics(Collections.emptyList(), conventions) : new JvmThreadMetrics();
    }

    @Bean
    @ConditionalOnMissingBean
    ClassLoaderMetrics classLoaderMetrics(ObjectProvider<JvmClassLoadingMeterConventions> jvmClassLoadingMeterConventions) {
        JvmClassLoadingMeterConventions conventions = (JvmClassLoadingMeterConventions)jvmClassLoadingMeterConventions.getIfAvailable();
        return conventions != null ? new ClassLoaderMetrics(conventions) : new ClassLoaderMetrics();
    }

    @Bean
    @ConditionalOnMissingBean
    JvmInfoMetrics jvmInfoMetrics() {
        return new JvmInfoMetrics();
    }

    @Bean
    @ConditionalOnMissingBean
    JvmCompilationMetrics jvmCompilationMetrics() {
        return new JvmCompilationMetrics();
    }

    static final class VirtualThreadMetricsRuntimeHintsRegistrar
    implements RuntimeHintsRegistrar {
        VirtualThreadMetricsRuntimeHintsRegistrar() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            hints.reflection().registerTypeIfPresent(classLoader, JvmMetricsAutoConfiguration.VIRTUAL_THREAD_METRICS_CLASS, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"io.micrometer.java21.instrument.binder.jdk.VirtualThreadMetrics"})
    static class VirtualThreadMetricsConfiguration {
        VirtualThreadMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(type={"io.micrometer.java21.instrument.binder.jdk.VirtualThreadMetrics"})
        @ImportRuntimeHints(value={VirtualThreadMetricsRuntimeHintsRegistrar.class})
        MeterBinder virtualThreadMetrics() throws ClassNotFoundException {
            Class virtualThreadMetricsClass = ClassUtils.forName((String)JvmMetricsAutoConfiguration.VIRTUAL_THREAD_METRICS_CLASS, (ClassLoader)this.getClass().getClassLoader());
            return (MeterBinder)BeanUtils.instantiateClass((Class)virtualThreadMetricsClass);
        }
    }
}

