/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure.export.dynatrace;

import io.micrometer.dynatrace.DynatraceApiVersion;
import io.micrometer.dynatrace.DynatraceConfig;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.dynatrace.DynatraceProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.properties.PropertiesConfigAdapter;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.properties.StepRegistryPropertiesConfigAdapter;

class DynatracePropertiesConfigAdapter
extends StepRegistryPropertiesConfigAdapter<DynatraceProperties>
implements DynatraceConfig {
    DynatracePropertiesConfigAdapter(DynatraceProperties properties) {
        super(properties);
    }

    public String prefix() {
        return "management.dynatrace.metrics.export";
    }

    public String apiToken() {
        return this.obtain(DynatraceProperties::getApiToken, () -> super.apiToken());
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public String deviceId() {
        return this.obtain(this.v1(DynatraceProperties.V1::getDeviceId), () -> super.deviceId());
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public String technologyType() {
        return this.obtain(this.v1(DynatraceProperties.V1::getTechnologyType), () -> super.technologyType());
    }

    public String uri() {
        return this.obtain(DynatraceProperties::getUri, () -> super.uri());
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public @Nullable String group() {
        return this.get(this.v1(DynatraceProperties.V1::getGroup), () -> super.group());
    }

    public DynatraceApiVersion apiVersion() {
        return this.obtain(properties -> properties.getV1().getDeviceId() != null ? DynatraceApiVersion.V1 : DynatraceApiVersion.V2, () -> super.apiVersion());
    }

    public String metricKeyPrefix() {
        return this.obtain(this.v2(DynatraceProperties.V2::getMetricKeyPrefix), () -> super.metricKeyPrefix());
    }

    public Map<String, String> defaultDimensions() {
        return this.obtain(this.v2(DynatraceProperties.V2::getDefaultDimensions), () -> super.defaultDimensions());
    }

    public boolean enrichWithDynatraceMetadata() {
        return this.obtain(this.v2(DynatraceProperties.V2::isEnrichWithDynatraceMetadata), () -> super.enrichWithDynatraceMetadata());
    }

    public boolean useDynatraceSummaryInstruments() {
        return this.obtain(this.v2(DynatraceProperties.V2::isUseDynatraceSummaryInstruments), () -> super.useDynatraceSummaryInstruments());
    }

    public boolean exportMeterMetadata() {
        return this.obtain(this.v2(DynatraceProperties.V2::isExportMeterMetadata), () -> super.exportMeterMetadata());
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    private <V> PropertiesConfigAdapter.Getter<DynatraceProperties, V> v1(PropertiesConfigAdapter.Getter<DynatraceProperties.V1, V> getter) {
        return properties -> getter.get(properties.getV1());
    }

    private <V> PropertiesConfigAdapter.Getter<DynatraceProperties, V> v2(PropertiesConfigAdapter.Getter<DynatraceProperties.V2, V> getter) {
        return properties -> getter.get(properties.getV2());
    }
}

