/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.metrics.autoconfigure.export.kairos;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.kairos.KairosConfig;
import io.micrometer.kairos.KairosMeterRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.metrics.autoconfigure.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.metrics.autoconfigure.export.kairos.KairosProperties;
import org.springframework.boot.metrics.autoconfigure.export.kairos.KairosPropertiesConfigAdapter;
import org.springframework.boot.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={KairosMeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="kairos")
@EnableConfigurationProperties(value={KairosProperties.class})
public class KairosMetricsExportAutoConfiguration {
    private final KairosProperties properties;

    public KairosMetricsExportAutoConfiguration(KairosProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public KairosConfig kairosConfig() {
        return new KairosPropertiesConfigAdapter(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public KairosMeterRegistry kairosMeterRegistry(KairosConfig kairosConfig, Clock clock) {
        return KairosMeterRegistry.builder((KairosConfig)kairosConfig).clock(clock).httpClient((HttpSender)new HttpUrlConnectionSender(this.properties.getConnectTimeout(), this.properties.getReadTimeout())).build();
    }
}

