/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.toolchain.ToolchainManager;
import org.springframework.boot.loader.tools.FileUtils;
import org.springframework.boot.maven.AbstractDependencyFilterMojo;
import org.springframework.boot.maven.EnvVariables;
import org.springframework.boot.maven.JavaProcessExecutor;
import org.springframework.boot.maven.RunArguments;
import org.springframework.boot.maven.SpringBootApplicationClassFinder;

public abstract class AbstractRunMojo
extends AbstractDependencyFilterMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(property="spring-boot.run.addResources", defaultValue="false")
    private boolean addResources = false;
    @Parameter(property="spring-boot.run.agents")
    private File[] agents;
    @Parameter(property="spring-boot.run.noverify")
    private boolean noverify = false;
    @Parameter(property="spring-boot.run.workingDirectory")
    private File workingDirectory;
    @Parameter(property="spring-boot.run.jvmArguments")
    private String jvmArguments;
    @Parameter
    private Map<String, String> systemPropertyVariables;
    @Parameter
    private Map<String, String> environmentVariables;
    @Parameter
    private String[] arguments;
    @Parameter(property="spring-boot.run.arguments")
    private String commandlineArguments;
    @Parameter(property="spring-boot.run.profiles")
    private String[] profiles;
    @Parameter(property="spring-boot.run.main-class")
    private String mainClass;
    @Parameter(property="spring-boot.run.directories")
    private String[] directories;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(property="spring-boot.run.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping run as per configuration.");
            return;
        }
        this.run(this.determineMainClass());
    }

    private String determineMainClass() throws MojoExecutionException {
        if (this.mainClass != null) {
            return this.mainClass;
        }
        return SpringBootApplicationClassFinder.findSingleClass(this.getClassesDirectories());
    }

    protected List<File> getClassesDirectories() {
        return List.of(this.classesDirectory);
    }

    protected abstract boolean isUseTestClasspath();

    private void run(String startClassName) throws MojoExecutionException, MojoFailureException {
        ArrayList<String> args = new ArrayList<String>();
        this.addAgents(args);
        this.addJvmArgs(args);
        this.addClasspath(args);
        args.add(startClassName);
        this.addArgs(args);
        JavaProcessExecutor processExecutor = new JavaProcessExecutor(this.session, this.toolchainManager);
        File workingDirectoryToUse = this.workingDirectory != null ? this.workingDirectory : this.project.getBasedir();
        this.run(processExecutor, workingDirectoryToUse, args, this.determineEnvironmentVariables());
    }

    protected abstract void run(JavaProcessExecutor var1, File var2, List<String> var3, Map<String, String> var4) throws MojoExecutionException, MojoFailureException;

    protected RunArguments resolveApplicationArguments() {
        RunArguments runArguments = this.arguments != null ? new RunArguments(this.arguments) : new RunArguments(this.commandlineArguments);
        this.addActiveProfileArgument(runArguments);
        return runArguments;
    }

    protected EnvVariables resolveEnvVariables() {
        return new EnvVariables(this.environmentVariables);
    }

    private void addArgs(List<String> args) {
        RunArguments applicationArguments = this.resolveApplicationArguments();
        Collections.addAll(args, applicationArguments.asArray());
        this.logArguments("Application argument(s): ", applicationArguments.asArray());
    }

    private Map<String, String> determineEnvironmentVariables() {
        EnvVariables envVariables = this.resolveEnvVariables();
        this.logArguments("Environment variable(s): ", envVariables.asArray());
        return envVariables.asMap();
    }

    protected RunArguments resolveJvmArguments() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.systemPropertyVariables != null) {
            stringBuilder.append(this.systemPropertyVariables.entrySet().stream().map(e -> SystemPropertyFormatter.format((String)e.getKey(), (String)e.getValue())).collect(Collectors.joining(" ")));
        }
        if (this.jvmArguments != null) {
            stringBuilder.append(" ").append(this.jvmArguments);
        }
        return new RunArguments(stringBuilder.toString());
    }

    private void addJvmArgs(List<String> args) {
        RunArguments jvmArguments = this.resolveJvmArguments();
        Collections.addAll(args, jvmArguments.asArray());
        this.logArguments("JVM argument(s): ", jvmArguments.asArray());
    }

    private void addAgents(List<String> args) {
        if (this.agents != null) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Attaching agents: " + Arrays.asList(this.agents)));
            }
            for (File agent : this.agents) {
                args.add("-javaagent:" + agent);
            }
        }
        if (this.noverify) {
            args.add("-noverify");
        }
    }

    private void addActiveProfileArgument(RunArguments arguments) {
        if (this.profiles.length > 0) {
            StringBuilder arg = new StringBuilder("--spring.profiles.active=");
            for (int i = 0; i < this.profiles.length; ++i) {
                arg.append(this.profiles[i]);
                if (i >= this.profiles.length - 1) continue;
                arg.append(",");
            }
            arguments.getArgs().addFirst(arg.toString());
            this.logArguments("Active profile(s): ", this.profiles);
        }
    }

    private void addClasspath(List<String> args) throws MojoExecutionException {
        try {
            StringBuilder classpath = new StringBuilder();
            for (URL ele : this.getClassPathUrls()) {
                if (!classpath.isEmpty()) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(new File(ele.toURI()));
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Classpath for forked process: " + classpath));
            }
            args.add("-cp");
            args.add(classpath.toString());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not build classpath", ex);
        }
    }

    protected URL[] getClassPathUrls() throws MojoExecutionException {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            this.addUserDefinedDirectories(urls);
            this.addResources(urls);
            this.addProjectClasses(urls);
            this.addDependencies(urls);
            return urls.toArray(new URL[0]);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to build classpath", (Exception)ex);
        }
    }

    private void addUserDefinedDirectories(List<URL> urls) throws MalformedURLException {
        if (this.directories != null) {
            for (String directory : this.directories) {
                urls.add(new File(directory).toURI().toURL());
            }
        }
    }

    private void addResources(List<URL> urls) throws IOException {
        if (this.addResources) {
            for (Resource resource : this.project.getResources()) {
                File directory = new File(resource.getDirectory());
                urls.add(directory.toURI().toURL());
                for (File classesDirectory : this.getClassesDirectories()) {
                    FileUtils.removeDuplicatesFromOutputDirectory((File)classesDirectory, (File)directory);
                }
            }
        }
    }

    private void addProjectClasses(List<URL> urls) throws MalformedURLException {
        for (File classesDirectory : this.getClassesDirectories()) {
            urls.add(classesDirectory.toURI().toURL());
        }
    }

    private void addDependencies(List<URL> urls) throws MalformedURLException, MojoExecutionException {
        Set<Artifact> artifacts = this.isUseTestClasspath() ? this.filterDependencies(this.project.getArtifacts(), new ArtifactsFilter[0]) : this.filterDependencies(this.project.getArtifacts(), new ArtifactsFilter[]{new AbstractDependencyFilterMojo.ExcludeTestScopeArtifactFilter()});
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null) continue;
            urls.add(artifact.getFile().toURI().toURL());
        }
    }

    private void logArguments(String message, String[] args) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)Arrays.stream(args).collect(Collectors.joining(" ", message, "")));
        }
    }

    static class SystemPropertyFormatter {
        SystemPropertyFormatter() {
        }

        static String format(String key, String value) {
            if (key == null) {
                return "";
            }
            if (value == null || value.isEmpty()) {
                return String.format("-D%s", key);
            }
            return String.format("-D%s=\"%s\"", key, value);
        }
    }
}

