/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mail.autoconfigure;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.health.autoconfigure.contributor.CompositeHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.mail.autoconfigure.MailSenderAutoConfiguration;
import org.springframework.boot.mail.health.MailHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@AutoConfiguration(after={MailSenderAutoConfiguration.class})
@ConditionalOnClass(value={JavaMailSenderImpl.class, MailHealthIndicator.class, ConditionalOnEnabledHealthIndicator.class})
@ConditionalOnBean(value={JavaMailSenderImpl.class})
@ConditionalOnEnabledHealthIndicator(value="mail")
public class MailHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<MailHealthIndicator, JavaMailSenderImpl> {
    public MailHealthContributorAutoConfiguration() {
        super(MailHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"mailHealthIndicator", "mailHealthContributor"})
    public HealthContributor mailHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (HealthContributor)this.createContributor(beanFactory, JavaMailSenderImpl.class);
    }
}

