/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.boot.loader.tools.LibraryCoordinates;

public final class ReachabilityMetadataProperties {
    public static final String REACHABILITY_METADATA_PROPERTIES_LOCATION_TEMPLATE = "META-INF/native-image/%s/%s/%s/reachability-metadata.properties";
    private final Properties properties;

    private ReachabilityMetadataProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean isOverridden() {
        return Boolean.parseBoolean(this.properties.getProperty("override"));
    }

    public static ReachabilityMetadataProperties fromInputStream(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        return new ReachabilityMetadataProperties(properties);
    }

    public static String getLocation(LibraryCoordinates coordinates) {
        return REACHABILITY_METADATA_PROPERTIES_LOCATION_TEMPLATE.formatted(coordinates.getGroupId(), coordinates.getArtifactId(), coordinates.getVersion());
    }
}

