/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.legacy.context.web;

import javax.servlet.ServletContext;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.legacy.context.web.AnnotationConfigNonEmbeddedWebApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class SpringBootContextLoaderListener
extends ContextLoaderListener {
    private static final String INIT_PARAM_DELIMITERS = ",; \t\n";

    public WebApplicationContext initWebApplicationContext(final ServletContext servletContext) {
        String configLocationParam = servletContext.getInitParameter("contextConfigLocation");
        SpringApplicationBuilder builder = new SpringApplicationBuilder((Object[])StringUtils.tokenizeToStringArray((String)configLocationParam, (String)INIT_PARAM_DELIMITERS));
        Class<?> contextClass = this.determineContextClass(servletContext);
        builder.contextClass(contextClass);
        builder.initializers(new ApplicationContextInitializer[]{new ApplicationContextInitializer<GenericWebApplicationContext>(){

            public void initialize(GenericWebApplicationContext applicationContext) {
                applicationContext.setServletContext(servletContext);
            }
        }});
        WebApplicationContext context = (WebApplicationContext)builder.run(new String[0]);
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)context);
        return context;
    }

    protected Class<?> determineContextClass(ServletContext servletContext) {
        String contextClassName = servletContext.getInitParameter("contextClass");
        if (contextClassName != null) {
            try {
                return ClassUtils.forName((String)contextClassName, null);
            }
            catch (Exception e) {
                throw new ApplicationContextException("Failed to load custom context class [" + contextClassName + "]", (Throwable)e);
            }
        }
        return AnnotationConfigNonEmbeddedWebApplicationContext.class;
    }
}

