/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jms.autoconfigure;

import io.micrometer.observation.ObservationRegistry;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.ExceptionListener;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.jms.autoconfigure.JmsProperties;
import org.springframework.jms.config.AbstractJmsListenerContainerFactory;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.util.Assert;

public abstract class AbstractJmsListenerContainerFactoryConfigurer<T extends AbstractJmsListenerContainerFactory<?>> {
    private @Nullable DestinationResolver destinationResolver;
    private @Nullable MessageConverter messageConverter;
    private @Nullable ExceptionListener exceptionListener;
    private @Nullable ObservationRegistry observationRegistry;
    private @Nullable JmsProperties jmsProperties;

    void setDestinationResolver(@Nullable DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    void setMessageConverter(@Nullable MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    void setExceptionListener(@Nullable ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    void setJmsProperties(@Nullable JmsProperties jmsProperties) {
        this.jmsProperties = jmsProperties;
    }

    void setObservationRegistry(@Nullable ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
    }

    protected JmsProperties getJmsProperties() {
        Assert.state((this.jmsProperties != null ? 1 : 0) != 0, (String)"'jmsProperties' must not be null");
        return this.jmsProperties;
    }

    public void configure(T factory, ConnectionFactory connectionFactory) {
        Assert.notNull(factory, (String)"'factory' must not be null");
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        JmsProperties properties = this.getJmsProperties();
        JmsProperties.Listener listenerProperties = properties.getListener();
        JmsProperties.Listener.Session sessionProperties = listenerProperties.getSession();
        factory.setConnectionFactory(connectionFactory);
        PropertyMapper map = PropertyMapper.get();
        map.from(properties::isPubSubDomain).to(arg_0 -> factory.setPubSubDomain(arg_0));
        map.from(properties::isSubscriptionDurable).to(arg_0 -> factory.setSubscriptionDurable(arg_0));
        map.from(properties::getClientId).to(arg_0 -> factory.setClientId(arg_0));
        map.from((Object)this.destinationResolver).to(arg_0 -> factory.setDestinationResolver(arg_0));
        map.from((Object)this.messageConverter).to(arg_0 -> factory.setMessageConverter(arg_0));
        map.from((Object)this.exceptionListener).to(arg_0 -> factory.setExceptionListener(arg_0));
        map.from(sessionProperties.getAcknowledgeMode()::getMode).to(arg_0 -> factory.setSessionAcknowledgeMode(arg_0));
        map.from((Object)this.observationRegistry).to(arg_0 -> factory.setObservationRegistry(arg_0));
        map.from(sessionProperties::getTransacted).to(arg_0 -> factory.setSessionTransacted(arg_0));
        map.from(listenerProperties::isAutoStartup).to(arg_0 -> factory.setAutoStartup(arg_0));
    }
}

