/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jms.autoconfigure;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Message;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jms.autoconfigure.AcknowledgeMode;
import org.springframework.boot.jms.autoconfigure.JmsAnnotationDrivenConfiguration;
import org.springframework.boot.jms.autoconfigure.JmsClientConfigurations;
import org.springframework.boot.jms.autoconfigure.JmsProperties;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.jms.core.JmsTemplate;

@AutoConfiguration
@ConditionalOnClass(value={Message.class, JmsTemplate.class})
@ConditionalOnBean(value={ConnectionFactory.class})
@EnableConfigurationProperties(value={JmsProperties.class})
@Import(value={JmsClientConfigurations.JmsTemplateConfiguration.class, JmsClientConfigurations.MessagingTemplateConfiguration.class, JmsClientConfigurations.JmsClientConfiguration.class, JmsAnnotationDrivenConfiguration.class})
@ImportRuntimeHints(value={JmsRuntimeHints.class})
public final class JmsAutoConfiguration {

    static class JmsRuntimeHints
    implements RuntimeHintsRegistrar {
        JmsRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            hints.reflection().registerType(TypeReference.of(AcknowledgeMode.class), type -> type.withMethod("of", List.of(TypeReference.of(String.class)), ExecutableMode.INVOKE));
        }
    }
}

