/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty;

import org.eclipse.jetty.compression.Compression;
import org.eclipse.jetty.compression.gzip.GzipCompression;
import org.eclipse.jetty.compression.server.CompressionConfig;
import org.eclipse.jetty.compression.server.CompressionHandler;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

final class JettyHandlerWrappers {
    private JettyHandlerWrappers() {
    }

    static Handler.Wrapper createGzipHandlerWrapper(org.springframework.boot.web.server.Compression compression) {
        CompressionHandler compressionHandler = new CompressionHandler();
        GzipCompression gzip = new GzipCompression();
        gzip.setMinCompressSize((int)compression.getMinResponseSize().toBytes());
        compressionHandler.putCompression((Compression)gzip);
        CompressionConfig.Builder configBuilder = CompressionConfig.builder();
        for (String string : compression.getAllMimeTypes()) {
            configBuilder.compressIncludeMimeType(string);
        }
        for (String string : HttpMethod.values()) {
            configBuilder.compressIncludeMethod(string.name());
        }
        compressionHandler.putConfiguration(PathSpec.from((String)"/"), configBuilder.build());
        return compressionHandler;
    }

    static Handler.Wrapper createServerHeaderHandlerWrapper(String header) {
        return new ServerHeaderHandler(header);
    }

    private static class ServerHeaderHandler
    extends Handler.Wrapper {
        private static final String SERVER_HEADER = "server";
        private final String value;

        ServerHeaderHandler(String value) {
            this.value = value;
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            HttpFields.Mutable headers = response.getHeaders();
            if (!headers.contains(SERVER_HEADER)) {
                headers.add(SERVER_HEADER, this.value);
            }
            return super.handle(request, response, callback);
        }
    }
}

