/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.autoconfigure;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.jetty.autoconfigure.JettyServerProperties;
import org.springframework.boot.jetty.autoconfigure.JettyThreadPool;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.unit.DataSize;

public class JettyWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableJettyWebServerFactory>,
Ordered {
    static final int ORDER = 0;
    private final Environment environment;
    private final ServerProperties serverProperties;
    private final JettyServerProperties jettyProperties;

    public JettyWebServerFactoryCustomizer(Environment environment, ServerProperties serverProperties, JettyServerProperties jettyProperties) {
        this.environment = environment;
        this.serverProperties = serverProperties;
        this.jettyProperties = jettyProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void customize(ConfigurableJettyWebServerFactory factory) {
        factory.setUseForwardHeaders(this.getOrDeduceUseForwardHeaders());
        JettyServerProperties.Threads threadProperties = this.jettyProperties.getThreads();
        factory.setThreadPool((ThreadPool)JettyThreadPool.create(this.jettyProperties.getThreads()));
        PropertyMapper map = PropertyMapper.get();
        map.from(this.jettyProperties::getMaxConnections).to(factory::setMaxConnections);
        map.from(threadProperties::getAcceptors).to(factory::setAcceptors);
        map.from(threadProperties::getSelectors).to(factory::setSelectors);
        map.from(() -> ((ServerProperties)this.serverProperties).getMaxHttpRequestHeaderSize()).asInt(DataSize::toBytes).when(this::isPositive).to(this.customizeHttpConfigurations(factory, HttpConfiguration::setRequestHeaderSize));
        map.from(this.jettyProperties::getMaxHttpResponseHeaderSize).asInt(DataSize::toBytes).when(this::isPositive).to(this.customizeHttpConfigurations(factory, HttpConfiguration::setMaxResponseHeaderSize));
        map.from(this.jettyProperties::getMaxHttpFormPostSize).asInt(DataSize::toBytes).when(this::isPositive).to(this.customizeServletContextHandler(factory, ServletContextHandler::setMaxFormContentSize));
        map.from(this.jettyProperties::getMaxFormKeys).when(this::isPositive).to(this.customizeServletContextHandler(factory, ServletContextHandler::setMaxFormKeys));
        map.from(this.jettyProperties::getConnectionIdleTimeout).as(Duration::toMillis).to(this.customizeAbstractConnectors(factory, AbstractConnector::setIdleTimeout));
        map.from(this.jettyProperties::getAccesslog).when(JettyServerProperties.Accesslog::isEnabled).to(accesslog -> this.customizeAccessLog(factory, (JettyServerProperties.Accesslog)accesslog));
    }

    private boolean isPositive(Integer value) {
        return value > 0;
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy() == null) {
            CloudPlatform platform = CloudPlatform.getActive((Environment)this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NATIVE);
    }

    private <T> Consumer<T> customizeHttpConfigurations(ConfigurableJettyWebServerFactory factory, BiConsumer<HttpConfiguration, T> action) {
        return this.customizeConnectionFactories(factory, HttpConfiguration.ConnectionFactory.class, (connectionFactory, value) -> action.accept(connectionFactory.getHttpConfiguration(), value));
    }

    private <V, F> Consumer<V> customizeConnectionFactories(ConfigurableJettyWebServerFactory factory, Class<F> connectionFactoryType, BiConsumer<F, V> action) {
        return this.customizeConnectors(factory, Connector.class, (connector, value) -> {
            Stream connectionFactories = connector.getConnectionFactories().stream();
            this.forEach(connectionFactories, connectionFactoryType, action, value);
        });
    }

    private <V> Consumer<V> customizeAbstractConnectors(ConfigurableJettyWebServerFactory factory, BiConsumer<AbstractConnector, V> action) {
        return this.customizeConnectors(factory, AbstractConnector.class, action);
    }

    private <V, C> Consumer<V> customizeConnectors(ConfigurableJettyWebServerFactory factory, Class<C> connectorType, BiConsumer<C, V> action) {
        return value -> factory.addServerCustomizers(server -> {
            Stream<Connector> connectors = Arrays.stream(server.getConnectors());
            this.forEach(connectors, connectorType, action, value);
        });
    }

    private <V> Consumer<V> customizeServletContextHandler(ConfigurableJettyWebServerFactory factory, BiConsumer<ServletContextHandler, V> action) {
        return this.customizeHandlers(factory, ServletContextHandler.class, action);
    }

    private <V, H> Consumer<V> customizeHandlers(ConfigurableJettyWebServerFactory factory, Class<H> handlerType, BiConsumer<H, V> action) {
        return value -> factory.addServerCustomizers(server -> {
            List handlers = server.getHandlers();
            this.forEachHandler(handlers, handlerType, action, value);
        });
    }

    private <V, H> void forEachHandler(List<Handler> handlers, Class<H> handlerType, BiConsumer<H, V> action, V value) {
        for (Handler handler : handlers) {
            if (handlerType.isInstance(handler)) {
                action.accept(handler, value);
            }
            if (handler instanceof Handler.Wrapper) {
                Handler.Wrapper wrapper = (Handler.Wrapper)handler;
                this.forEachHandler(wrapper.getHandlers(), handlerType, action, value);
            }
            if (!(handler instanceof Handler.Collection)) continue;
            Handler.Collection collection = (Handler.Collection)handler;
            this.forEachHandler(collection.getHandlers(), handlerType, action, value);
        }
    }

    private <T, V> void forEach(Stream<?> elements, Class<T> type, BiConsumer<T, V> action, V value) {
        elements.filter(type::isInstance).map(type::cast).forEach(element -> action.accept(element, value));
    }

    private void customizeAccessLog(ConfigurableJettyWebServerFactory factory, JettyServerProperties.Accesslog properties) {
        factory.addServerCustomizers(server -> {
            RequestLogWriter logWriter = new RequestLogWriter();
            String format = this.getLogFormat(properties);
            CustomRequestLog log = new CustomRequestLog((RequestLog.Writer)logWriter, format);
            if (!CollectionUtils.isEmpty(properties.getIgnorePaths())) {
                log.setIgnorePaths(properties.getIgnorePaths().toArray(new String[0]));
            }
            if (properties.getFilename() != null) {
                logWriter.setFilename(properties.getFilename());
            }
            if (properties.getFileDateFormat() != null) {
                logWriter.setFilenameDateFormat(properties.getFileDateFormat());
            }
            logWriter.setRetainDays(properties.getRetentionPeriod());
            logWriter.setAppend(properties.isAppend());
            server.setRequestLog((RequestLog)log);
        });
    }

    private String getLogFormat(JettyServerProperties.Accesslog properties) {
        if (properties.getCustomFormat() != null) {
            return properties.getCustomFormat();
        }
        if (JettyServerProperties.Accesslog.Format.EXTENDED_NCSA.equals((Object)properties.getFormat())) {
            return "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"";
        }
        return "%{client}a - %u %t \"%r\" %s %O";
    }
}

