/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty;

import java.net.InetSocketAddress;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.jetty.JettyServerCustomizer;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.web.server.Http2;
import org.springframework.boot.web.server.Ssl;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class SslServerCustomizer
implements JettyServerCustomizer {
    private final @Nullable Http2 http2;
    private final InetSocketAddress address;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Ssl.ClientAuth clientAuth;
    private final SslBundle sslBundle;

    SslServerCustomizer(@Nullable Http2 http2, InetSocketAddress address, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Ssl.ClientAuth clientAuth, SslBundle sslBundle) {
        this.address = address;
        this.clientAuth = clientAuth;
        this.sslBundle = sslBundle;
        this.http2 = http2;
    }

    @Override
    public void customize(Server server) {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setEndpointIdentificationAlgorithm(null);
        this.configureSsl(sslContextFactory, this.clientAuth);
        ServerConnector connector = this.createConnector(server, sslContextFactory);
        server.setConnectors(new Connector[]{connector});
    }

    private ServerConnector createConnector(Server server, SslContextFactory.Server sslContextFactory) {
        HttpConfiguration config = new HttpConfiguration();
        config.setSendServerVersion(false);
        config.setSecureScheme("https");
        config.setSecurePort(this.address.getPort());
        config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector connector = this.createServerConnector(server, sslContextFactory, config);
        connector.setPort(this.address.getPort());
        connector.setHost(this.address.getHostString());
        return connector;
    }

    private ServerConnector createServerConnector(Server server, SslContextFactory.Server sslContextFactory, HttpConfiguration config) {
        if (this.http2 == null || !this.http2.isEnabled()) {
            return this.createHttp11ServerConnector(config, sslContextFactory, server);
        }
        Assert.state((boolean)this.isJettyAlpnPresent(), () -> "An 'org.eclipse.jetty:jetty-alpn-*-server' dependency is required for HTTP/2 support.");
        Assert.state((boolean)this.isJettyHttp2Present(), () -> "The 'org.eclipse.jetty.http2:jetty-http2-server' dependency is required for HTTP/2 support.");
        return this.createHttp2ServerConnector(config, sslContextFactory, server);
    }

    private ServerConnector createHttp11ServerConnector(HttpConfiguration config, SslContextFactory.Server sslContextFactory, Server server) {
        SslConnectionFactory sslConnectionFactory = this.createSslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
        HttpConnectionFactory connectionFactory = new HttpConnectionFactory(config);
        return new SslValidatingServerConnector(this.sslBundle.getKey(), (SslContextFactory)sslContextFactory, server, sslConnectionFactory, connectionFactory);
    }

    private SslConnectionFactory createSslConnectionFactory(SslContextFactory.Server sslContextFactory, String protocol) {
        return new SslConnectionFactory(sslContextFactory, protocol);
    }

    private boolean isJettyAlpnPresent() {
        return ClassUtils.isPresent((String)"org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory", null);
    }

    private boolean isJettyHttp2Present() {
        return ClassUtils.isPresent((String)"org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory", null);
    }

    private ServerConnector createHttp2ServerConnector(HttpConfiguration config, SslContextFactory.Server sslContextFactory, Server server) {
        HttpConnectionFactory http = new HttpConnectionFactory(config);
        HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(config);
        ALPNServerConnectionFactory alpn = this.createAlpnServerConnectionFactory();
        sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
        if (this.isConscryptPresent()) {
            sslContextFactory.setProvider("Conscrypt");
        }
        SslConnectionFactory sslConnectionFactory = this.createSslConnectionFactory(sslContextFactory, alpn.getProtocol());
        return new SslValidatingServerConnector(this.sslBundle.getKey(), (SslContextFactory)sslContextFactory, server, new ConnectionFactory[]{sslConnectionFactory, alpn, h2, http});
    }

    private ALPNServerConnectionFactory createAlpnServerConnectionFactory() {
        try {
            return new ALPNServerConnectionFactory(new String[0]);
        }
        catch (IllegalStateException ex) {
            throw new IllegalStateException("An 'org.eclipse.jetty:jetty-alpn-*-server' dependency is required for HTTP/2 support.", ex);
        }
    }

    private boolean isConscryptPresent() {
        return ClassUtils.isPresent((String)"org.conscrypt.Conscrypt", null) && ClassUtils.isPresent((String)"org.eclipse.jetty.alpn.conscrypt.server.ConscryptServerALPNProcessor", null);
    }

    protected void configureSsl(SslContextFactory.Server factory, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Ssl.ClientAuth clientAuth) {
        SslBundleKey key = this.sslBundle.getKey();
        SslOptions options = this.sslBundle.getOptions();
        SslStoreBundle stores = this.sslBundle.getStores();
        factory.setProtocol(this.sslBundle.getProtocol());
        this.configureSslClientAuth(factory, clientAuth);
        if (stores.getKeyStorePassword() != null) {
            factory.setKeyStorePassword(stores.getKeyStorePassword());
        }
        factory.setCertAlias(key.getAlias());
        if (options.getCiphers() != null) {
            factory.setIncludeCipherSuites(options.getCiphers());
            factory.setExcludeCipherSuites(new String[0]);
        }
        if (options.getEnabledProtocols() != null) {
            factory.setIncludeProtocols(options.getEnabledProtocols());
            factory.setExcludeProtocols(new String[0]);
        }
        try {
            if (key.getPassword() != null) {
                factory.setKeyManagerPassword(key.getPassword());
            }
            factory.setKeyStore(stores.getKeyStore());
            factory.setTrustStore(stores.getTrustStore());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to set SSL store: " + ex.getMessage(), ex);
        }
    }

    private void configureSslClientAuth(SslContextFactory.Server factory, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Ssl.ClientAuth clientAuth) {
        factory.setWantClientAuth(clientAuth == Ssl.ClientAuth.WANT || clientAuth == Ssl.ClientAuth.NEED);
        factory.setNeedClientAuth(clientAuth == Ssl.ClientAuth.NEED);
    }

    static class SslValidatingServerConnector
    extends ServerConnector {
        private final SslBundleKey key;
        private final SslContextFactory sslContextFactory;

        SslValidatingServerConnector(SslBundleKey key, SslContextFactory sslContextFactory, Server server, SslConnectionFactory sslConnectionFactory, HttpConnectionFactory connectionFactory) {
            super(server, new ConnectionFactory[]{sslConnectionFactory, connectionFactory});
            this.key = key;
            this.sslContextFactory = sslContextFactory;
        }

        SslValidatingServerConnector(SslBundleKey keyAlias, SslContextFactory sslContextFactory, Server server, ConnectionFactory ... factories) {
            super(server, factories);
            this.key = keyAlias;
            this.sslContextFactory = sslContextFactory;
        }

        protected void doStart() throws Exception {
            super.doStart();
            this.key.assertContainsAlias(this.sslContextFactory.getKeyStore());
        }
    }
}

