/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.metrics;

import org.eclipse.jetty.server.Server;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.jetty.JettyWebServer;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.context.WebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;

public abstract class AbstractJettyMetricsBinder
implements ApplicationListener<ApplicationStartedEvent> {
    public void onApplicationEvent(ApplicationStartedEvent event) {
        Server server = this.findServer((ApplicationContext)event.getApplicationContext());
        if (server != null) {
            this.bindMetrics(server);
        }
    }

    private Server findServer(ApplicationContext applicationContext) {
        WebServerApplicationContext webServerApplicationContext;
        WebServer webServer;
        if (applicationContext instanceof WebServerApplicationContext && (webServer = (webServerApplicationContext = (WebServerApplicationContext)applicationContext).getWebServer()) instanceof JettyWebServer) {
            JettyWebServer jettyWebServer = (JettyWebServer)webServer;
            return jettyWebServer.getServer();
        }
        return null;
    }

    protected abstract void bindMetrics(Server var1);
}

