/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jersey.autoconfigure;

import jakarta.ws.rs.ApplicationPath;
import org.glassfish.jersey.server.ResourceConfig;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.jersey.autoconfigure.JerseyApplicationPath;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.StringUtils;

public class DefaultJerseyApplicationPath
implements JerseyApplicationPath {
    private final @Nullable String applicationPath;
    private final ResourceConfig config;

    public DefaultJerseyApplicationPath(@Nullable String applicationPath, ResourceConfig config) {
        this.applicationPath = applicationPath;
        this.config = config;
    }

    @Override
    public String getPath() {
        return this.resolveApplicationPath();
    }

    private String resolveApplicationPath() {
        if (StringUtils.hasLength((String)this.applicationPath)) {
            return this.applicationPath;
        }
        return MergedAnnotations.from(this.config.getApplication().getClass(), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(ApplicationPath.class).getValue("value", String.class).orElse("/*");
    }
}

