/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jersey.autoconfigure.actuate.endpoint.web;

import jakarta.servlet.Servlet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.servlet.ServletContainer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jersey.actuate.endpoint.web.JerseyHealthEndpointAdditionalPathResourceFactory;
import org.springframework.boot.jersey.autoconfigure.DefaultJerseyApplicationPath;
import org.springframework.boot.jersey.autoconfigure.JerseyApplicationPath;
import org.springframework.boot.jersey.autoconfigure.JerseyProperties;
import org.springframework.boot.jersey.autoconfigure.ResourceConfigCustomizer;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnBean(value={HealthEndpoint.class})
@ConditionalOnAvailableEndpoint(endpoint=HealthEndpoint.class, exposure={EndpointExposure.WEB})
@ConditionalOnMissingClass(value={"org.springframework.web.servlet.DispatcherServlet"})
public final class HealthEndpointJerseyExtensionAutoConfiguration {
    @Bean
    JerseyAdditionalHealthEndpointPathsResourcesRegistrar jerseyAdditionalHealthEndpointPathsResourcesRegistrar(WebEndpointsSupplier webEndpointsSupplier, HealthEndpointGroups healthEndpointGroups) {
        ExposableWebEndpoint health = HealthEndpointJerseyExtensionAutoConfiguration.getHealthEndpoint(webEndpointsSupplier);
        return new JerseyAdditionalHealthEndpointPathsResourcesRegistrar(health, healthEndpointGroups);
    }

    private static @Nullable ExposableWebEndpoint getHealthEndpoint(WebEndpointsSupplier webEndpointsSupplier) {
        Collection webEndpoints = webEndpointsSupplier.getEndpoints();
        return webEndpoints.stream().filter(endpoint -> endpoint.getEndpointId().equals((Object)HealthEndpoint.ID)).findFirst().orElse(null);
    }

    static class JerseyAdditionalHealthEndpointPathsResourcesRegistrar
    implements ResourceConfigCustomizer {
        private final @Nullable ExposableWebEndpoint endpoint;
        private final HealthEndpointGroups groups;

        JerseyAdditionalHealthEndpointPathsResourcesRegistrar(@Nullable ExposableWebEndpoint endpoint, HealthEndpointGroups groups) {
            this.endpoint = endpoint;
            this.groups = groups;
        }

        @Override
        public void customize(ResourceConfig config) {
            this.register(config);
        }

        private void register(ResourceConfig config) {
            EndpointMapping mapping = new EndpointMapping("");
            JerseyHealthEndpointAdditionalPathResourceFactory resourceFactory = new JerseyHealthEndpointAdditionalPathResourceFactory(WebServerNamespace.SERVER, this.groups);
            List<Resource> endpointResources = resourceFactory.createEndpointResources(mapping, this.endpoint != null ? Collections.singletonList(this.endpoint) : Collections.emptyList()).stream().filter(Objects::nonNull).toList();
            this.register(endpointResources, config);
        }

        private void register(Collection<Resource> resources, ResourceConfig config) {
            config.registerResources(new HashSet<Resource>(resources));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={ResourceConfig.class})
    @EnableConfigurationProperties(value={JerseyProperties.class})
    static class JerseyInfrastructureConfiguration {
        JerseyInfrastructureConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        JerseyApplicationPath jerseyApplicationPath(JerseyProperties properties, ResourceConfig config) {
            return new DefaultJerseyApplicationPath(properties.getApplicationPath(), config);
        }

        @Bean
        ResourceConfig resourceConfig(ObjectProvider<ResourceConfigCustomizer> resourceConfigCustomizers) {
            ResourceConfig resourceConfig = new ResourceConfig();
            resourceConfigCustomizers.orderedStream().forEach(customizer -> customizer.customize(resourceConfig));
            return resourceConfig;
        }

        @Bean
        ServletRegistrationBean<ServletContainer> jerseyServletRegistration(JerseyApplicationPath jerseyApplicationPath, ResourceConfig resourceConfig) {
            return new ServletRegistrationBean((Servlet)new ServletContainer(resourceConfig), new String[]{jerseyApplicationPath.getUrlMapping()});
        }
    }
}

