/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.tools;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.jarmode.tools.Command;
import org.springframework.boot.jarmode.tools.Context;
import org.springframework.boot.jarmode.tools.Layers;
import org.springframework.boot.jarmode.tools.ListLayersCommand;

class ListCommand
extends Command {
    private final ListLayersCommand delegate;

    ListCommand(Context context) {
        super("list", "List layers from the jar that can be extracted", Command.Options.none(), Command.Parameters.none());
        this.delegate = new ListLayersCommand(context);
    }

    @Override
    boolean isDeprecated() {
        return true;
    }

    @Override
    String getDeprecationMessage() {
        return "Use '-Djarmode=tools list-layers' instead.";
    }

    @Override
    void run(PrintStream out, Map<Command.Option, @Nullable String> options, List<String> parameters) {
        this.delegate.run(out, options, parameters);
    }

    void printLayers(Layers layers, PrintStream out) {
        this.delegate.printLayers(out, layers);
    }
}

