/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.layertools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.boot.jarmode.layertools.Command;
import org.springframework.boot.jarmode.layertools.Context;
import org.springframework.boot.jarmode.layertools.Layers;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

class ExtractCommand
extends Command {
    static final Command.Option DESTINATION_OPTION = Command.Option.of("destination", "string", "The destination to extract files to");
    private final Context context;
    private final Layers layers;

    ExtractCommand(Context context) {
        this(context, Layers.get(context));
    }

    ExtractCommand(Context context, Layers layers) {
        super("extract", "Extracts layers from the jar for image creation", Command.Options.of(DESTINATION_OPTION), Command.Parameters.of("[<layer>...]"));
        this.context = context;
        this.layers = layers;
    }

    @Override
    protected void run(Map<Command.Option, String> options, List<String> parameters) {
        try {
            File destination = options.containsKey(DESTINATION_OPTION) ? new File(options.get(DESTINATION_OPTION)) : this.context.getWorkingDir();
            for (String layer : this.layers) {
                if (!parameters.isEmpty() && !parameters.contains(layer)) continue;
                this.mkDirs(new File(destination, layer));
            }
            try (ZipInputStream zip = new ZipInputStream(new FileInputStream(this.context.getJarFile()));){
                ZipEntry entry = zip.getNextEntry();
                Assert.state((entry != null ? 1 : 0) != 0, (String)("File '" + this.context.getJarFile().toString() + "' is not compatible with layertools; ensure jar file is valid and launch script is not enabled"));
                while (entry != null) {
                    if (!entry.isDirectory()) {
                        String layer = this.layers.getLayer(entry);
                        if (parameters.isEmpty() || parameters.contains(layer)) {
                            this.write(zip, entry, new File(destination, layer));
                        }
                    }
                    entry = zip.getNextEntry();
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void write(ZipInputStream zip, ZipEntry entry, File destination) throws IOException {
        String canonicalOutputPath = destination.getCanonicalPath() + File.separator;
        File file = new File(destination, entry.getName());
        String canonicalEntryPath = file.getCanonicalPath();
        Assert.state((boolean)canonicalEntryPath.startsWith(canonicalOutputPath), () -> "Entry '" + entry.getName() + "' would be written to '" + canonicalEntryPath + "'. This is outside the output location of '" + canonicalOutputPath + "'. Verify the contents of your archive.");
        this.mkParentDirs(file);
        try (FileOutputStream out = new FileOutputStream(file);){
            StreamUtils.copy((InputStream)zip, (OutputStream)out);
        }
        Files.setAttribute(file.toPath(), "creationTime", entry.getCreationTime(), new LinkOption[0]);
    }

    private void mkParentDirs(File file) throws IOException {
        this.mkDirs(file.getParentFile());
    }

    private void mkDirs(File file) throws IOException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Unable to create directory " + file);
        }
    }
}

