/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.converter.autoconfigure;

import kotlinx.serialization.Serializable;
import kotlinx.serialization.json.Json;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.http.converter.autoconfigure.ClientHttpMessageConvertersCustomizer;
import org.springframework.boot.http.converter.autoconfigure.ServerHttpMessageConvertersCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.http.converter.json.KotlinSerializationJsonHttpMessageConverter;
import org.springframework.util.ClassUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Serializable.class, Json.class})
@ConditionalOnBean(value={Json.class})
class KotlinSerializationHttpMessageConvertersConfiguration {
    KotlinSerializationHttpMessageConvertersConfiguration() {
    }

    @Bean
    @Order(value=0)
    @ConditionalOnMissingBean(value={KotlinSerializationJsonHttpMessageConverter.class})
    KotlinSerializationJsonConvertersCustomizer kotlinSerializationJsonConvertersCustomizer(Json json, ResourceLoader resourceLoader) {
        return new KotlinSerializationJsonConvertersCustomizer(json, resourceLoader);
    }

    static class KotlinSerializationJsonConvertersCustomizer
    implements ClientHttpMessageConvertersCustomizer,
    ServerHttpMessageConvertersCustomizer {
        private final KotlinSerializationJsonHttpMessageConverter converter;

        KotlinSerializationJsonConvertersCustomizer(Json json, ResourceLoader resourceLoader) {
            ClassLoader classLoader = resourceLoader.getClassLoader();
            boolean hasAnyJsonSupport = ClassUtils.isPresent((String)"tools.jackson.databind.json.JsonMapper", (ClassLoader)classLoader) || ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader) || ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)classLoader);
            this.converter = hasAnyJsonSupport ? new KotlinSerializationJsonHttpMessageConverter(json) : new KotlinSerializationJsonHttpMessageConverter(json, type -> true);
        }

        @Override
        public void customize(HttpMessageConverters.ClientBuilder builder) {
            builder.withKotlinSerializationJsonConverter((HttpMessageConverter)this.converter);
        }

        @Override
        public void customize(HttpMessageConverters.ServerBuilder builder) {
            builder.withKotlinSerializationJsonConverter((HttpMessageConverter)this.converter);
        }
    }
}

