/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.converter.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.converter.autoconfigure.ClientHttpMessageConvertersCustomizer;
import org.springframework.boot.http.converter.autoconfigure.DefaultClientHttpMessageConvertersCustomizer;
import org.springframework.boot.http.converter.autoconfigure.DefaultServerHttpMessageConvertersCustomizer;
import org.springframework.boot.http.converter.autoconfigure.GsonHttpMessageConvertersConfiguration;
import org.springframework.boot.http.converter.autoconfigure.HttpMessageConverters;
import org.springframework.boot.http.converter.autoconfigure.HttpMessageConvertersProperties;
import org.springframework.boot.http.converter.autoconfigure.Jackson2HttpMessageConvertersConfiguration;
import org.springframework.boot.http.converter.autoconfigure.JacksonHttpMessageConvertersConfiguration;
import org.springframework.boot.http.converter.autoconfigure.JsonbHttpMessageConvertersConfiguration;
import org.springframework.boot.http.converter.autoconfigure.KotlinSerializationHttpMessageConvertersConfiguration;
import org.springframework.boot.http.converter.autoconfigure.ServerHttpMessageConvertersCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.http.converter.StringHttpMessageConverter;

@AutoConfiguration(afterName={"org.springframework.boot.jackson.autoconfigure.JacksonAutoConfiguration", "org.springframework.boot.jackson2.autoconfigure.Jackson2AutoConfiguration", "org.springframework.boot.jsonb.autoconfigure.JsonbAutoConfiguration", "org.springframework.boot.gson.autoconfigure.GsonAutoConfiguration", "org.springframework.boot.kotlinx.serialization.json.autoconfigure.KotlinxSerializationJsonAutoConfiguration"})
@ConditionalOnClass(value={HttpMessageConverter.class})
@Conditional(value={NotReactiveWebApplicationCondition.class})
@Import(value={JacksonHttpMessageConvertersConfiguration.class, Jackson2HttpMessageConvertersConfiguration.class, GsonHttpMessageConvertersConfiguration.class, JsonbHttpMessageConvertersConfiguration.class, KotlinSerializationHttpMessageConvertersConfiguration.class})
public final class HttpMessageConvertersAutoConfiguration {
    static final String PREFERRED_MAPPER_PROPERTY = "spring.http.converters.preferred-json-mapper";

    @Bean
    @Order(value=0)
    ClientHttpMessageConvertersCustomizer clientConvertersCustomizer(ObjectProvider<HttpMessageConverters> legacyConverters, ObjectProvider<HttpMessageConverter<?>> converters) {
        return new DefaultClientHttpMessageConvertersCustomizer((HttpMessageConverters)legacyConverters.getIfAvailable(), converters.orderedStream().toList());
    }

    @Bean
    @Order(value=0)
    ServerHttpMessageConvertersCustomizer serverConvertersCustomizer(ObjectProvider<HttpMessageConverters> legacyConverters, ObjectProvider<HttpMessageConverter<?>> converters) {
        return new DefaultServerHttpMessageConvertersCustomizer((HttpMessageConverters)legacyConverters.getIfAvailable(), converters.orderedStream().toList());
    }

    static class NotReactiveWebApplicationCondition
    extends NoneNestedConditions {
        NotReactiveWebApplicationCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
        private static final class ReactiveWebApplication {
            private ReactiveWebApplication() {
            }
        }
    }

    static class StringHttpMessageConvertersCustomizer
    implements ClientHttpMessageConvertersCustomizer,
    ServerHttpMessageConvertersCustomizer {
        StringHttpMessageConverter converter;

        StringHttpMessageConvertersCustomizer(HttpMessageConvertersProperties properties) {
            this.converter = new StringHttpMessageConverter(properties.getStringEncodingCharset());
            this.converter.setWriteAcceptCharset(false);
        }

        @Override
        public void customize(HttpMessageConverters.ClientBuilder builder) {
            builder.withStringConverter((HttpMessageConverter)this.converter);
        }

        @Override
        public void customize(HttpMessageConverters.ServerBuilder builder) {
            builder.withStringConverter((HttpMessageConverter)this.converter);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={HttpMessageConvertersProperties.class})
    protected static class StringHttpMessageConverterConfiguration {
        protected StringHttpMessageConverterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={StringHttpMessageConverter.class})
        StringHttpMessageConvertersCustomizer stringHttpMessageConvertersCustomizer(HttpMessageConvertersProperties properties) {
            return new StringHttpMessageConvertersCustomizer(properties);
        }
    }
}

