/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.autoconfigure.HttpClientSettingsProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.Assert;

public class HttpClientSettingsPropertyMapper {
    private final @Nullable SslBundles sslBundles;
    private final HttpClientSettings settings;

    public HttpClientSettingsPropertyMapper(@Nullable SslBundles sslBundles, @Nullable HttpClientSettings settings) {
        this.sslBundles = sslBundles;
        this.settings = settings != null ? settings : HttpClientSettings.defaults();
    }

    public HttpClientSettings map(@Nullable HttpClientSettingsProperties properties) {
        HttpClientSettings settings = HttpClientSettings.defaults();
        if (properties != null) {
            PropertyMapper map = PropertyMapper.get();
            settings = (HttpClientSettings)map.from(properties::getRedirects).to((Object)settings, HttpClientSettings::withRedirects);
            settings = (HttpClientSettings)map.from(properties::getConnectTimeout).to((Object)settings, HttpClientSettings::withConnectTimeout);
            settings = (HttpClientSettings)map.from(properties::getReadTimeout).to((Object)settings, HttpClientSettings::withReadTimeout);
            settings = (HttpClientSettings)map.from(properties::getSsl).as(HttpClientSettingsProperties.Ssl::getBundle).as(this::getSslBundle).to((Object)settings, HttpClientSettings::withSslBundle);
        }
        return settings.orElse(this.settings);
    }

    private SslBundle getSslBundle(String name) {
        Assert.state((this.sslBundles != null ? 1 : 0) != 0, (String)"No 'sslBundles' available");
        return this.sslBundles.getBundle(name);
    }
}

