/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.reactive;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.http.client.HttpComponentsHttpAsyncClientBuilder;
import org.springframework.boot.http.client.reactive.AbstractClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.http.client.reactive.HttpComponentsClientHttpConnector;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class HttpComponentsClientHttpConnectorBuilder
extends AbstractClientHttpConnectorBuilder<HttpComponentsClientHttpConnector> {
    private final HttpComponentsHttpAsyncClientBuilder httpClientBuilder;

    HttpComponentsClientHttpConnectorBuilder() {
        this(null, new HttpComponentsHttpAsyncClientBuilder());
    }

    private HttpComponentsClientHttpConnectorBuilder(@Nullable List<Consumer<HttpComponentsClientHttpConnector>> customizers, HttpComponentsHttpAsyncClientBuilder httpClientBuilder) {
        super(customizers);
        this.httpClientBuilder = httpClientBuilder;
    }

    public HttpComponentsClientHttpConnectorBuilder withHttpClientCustomizer(Consumer<HttpAsyncClientBuilder> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, (String)"'customizer' must not be null");
        return new HttpComponentsClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withCustomizer(httpClientCustomizer));
    }

    public HttpComponentsClientHttpConnectorBuilder withConnectionManagerCustomizer(Consumer<PoolingAsyncClientConnectionManagerBuilder> connectionManagerCustomizer) {
        Assert.notNull(connectionManagerCustomizer, (String)"'connectionManagerCustomizer' must not be null");
        return new HttpComponentsClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withConnectionManagerCustomizer(connectionManagerCustomizer));
    }

    public HttpComponentsClientHttpConnectorBuilder withConnectionConfigCustomizer(Consumer<ConnectionConfig.Builder> connectionConfigCustomizer) {
        Assert.notNull(connectionConfigCustomizer, (String)"'connectionConfigCustomizer' must not be null");
        return new HttpComponentsClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withConnectionConfigCustomizer(connectionConfigCustomizer));
    }

    public HttpComponentsClientHttpConnectorBuilder withTlsSocketStrategyFactory(Function<@Nullable SslBundle, @Nullable TlsStrategy> tlsStrategyFactory) {
        Assert.notNull(tlsStrategyFactory, (String)"'tlsStrategyFactory' must not be null");
        return new HttpComponentsClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withTlsStrategyFactory(tlsStrategyFactory));
    }

    public HttpComponentsClientHttpConnectorBuilder withDefaultRequestConfigCustomizer(Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer) {
        Assert.notNull(defaultRequestConfigCustomizer, (String)"'defaultRequestConfigCustomizer' must not be null");
        return new HttpComponentsClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withDefaultRequestConfigCustomizer(defaultRequestConfigCustomizer));
    }

    public HttpComponentsClientHttpConnectorBuilder with(UnaryOperator<HttpComponentsClientHttpConnectorBuilder> customizer) {
        return (HttpComponentsClientHttpConnectorBuilder)customizer.apply(this);
    }

    @Override
    protected HttpComponentsClientHttpConnector createClientHttpConnector(ClientHttpConnectorSettings settings) {
        CloseableHttpAsyncClient client = this.httpClientBuilder.build(this.asHttpClientSettings(settings));
        return new HttpComponentsClientHttpConnector(client);
    }

    static class Classes {
        static final String HTTP_CLIENTS = "org.apache.hc.client5.http.impl.async.HttpAsyncClients";
        static final String REACTIVE_RESPONSE_CONSUMER = "org.apache.hc.core5.reactive.ReactiveResponseConsumer";

        Classes() {
        }

        static boolean present(@Nullable ClassLoader classLoader) {
            return ClassUtils.isPresent((String)HTTP_CLIENTS, (ClassLoader)classLoader) && ClassUtils.isPresent((String)REACTIVE_RESPONSE_CONSUMER, (ClassLoader)classLoader);
        }
    }
}

