/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.http.client.autoconfigure.AbstractHttpRequestFactoryProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.StringUtils;

public final class ClientHttpRequestFactories {
    private final ObjectFactory<SslBundles> sslBundles;
    private final AbstractHttpRequestFactoryProperties[] orderedProperties;

    public ClientHttpRequestFactories(ObjectFactory<SslBundles> sslBundles, AbstractHttpRequestFactoryProperties ... orderedProperties) {
        this.sslBundles = sslBundles;
        this.orderedProperties = orderedProperties;
    }

    public ClientHttpRequestFactoryBuilder<?> builder(ClassLoader classLoader) {
        AbstractHttpRequestFactoryProperties.Factory factory = this.getProperty(AbstractHttpRequestFactoryProperties::getFactory);
        return factory != null ? factory.builder() : ClientHttpRequestFactoryBuilder.detect(classLoader);
    }

    public ClientHttpRequestFactorySettings settings() {
        HttpRedirects redirects = this.getProperty(AbstractHttpRequestFactoryProperties::getRedirects);
        Duration connectTimeout = this.getProperty(AbstractHttpRequestFactoryProperties::getConnectTimeout);
        Duration readTimeout = this.getProperty(AbstractHttpRequestFactoryProperties::getReadTimeout);
        String sslBundleName = this.getProperty(AbstractHttpRequestFactoryProperties::getSsl, AbstractHttpRequestFactoryProperties.Ssl::getBundle, StringUtils::hasLength);
        SslBundle sslBundle = StringUtils.hasLength((String)sslBundleName) ? ((SslBundles)this.sslBundles.getObject()).getBundle(sslBundleName) : null;
        return new ClientHttpRequestFactorySettings(redirects, connectTimeout, readTimeout, sslBundle);
    }

    private <T> T getProperty(Function<AbstractHttpRequestFactoryProperties, T> accessor) {
        return (T)this.getProperty(accessor, Function.identity(), Objects::nonNull);
    }

    private <P, T> T getProperty(Function<AbstractHttpRequestFactoryProperties, P> accessor, Function<P, T> extractor, Predicate<T> predicate) {
        for (AbstractHttpRequestFactoryProperties properties : this.orderedProperties) {
            T extracted;
            if (properties == null) continue;
            P value = accessor.apply(properties);
            T t = extracted = value != null ? (T)extractor.apply(value) : null;
            if (!predicate.test(extracted)) continue;
            return extracted;
        }
        return null;
    }
}

