/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure;

import java.time.Duration;
import java.util.function.Supplier;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.HttpRedirects;

public abstract class AbstractHttpRequestFactoryProperties {
    private HttpRedirects redirects;
    private Duration connectTimeout;
    private Duration readTimeout;
    private final Ssl ssl = new Ssl();
    private Factory factory;

    public HttpRedirects getRedirects() {
        return this.redirects;
    }

    public void setRedirects(HttpRedirects redirects) {
        this.redirects = redirects;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public Factory getFactory() {
        return this.factory;
    }

    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    public static class Ssl {
        private String bundle;

        public String getBundle() {
            return this.bundle;
        }

        public void setBundle(String bundle) {
            this.bundle = bundle;
        }
    }

    public static enum Factory {
        HTTP_COMPONENTS(ClientHttpRequestFactoryBuilder::httpComponents),
        JETTY(ClientHttpRequestFactoryBuilder::jetty),
        REACTOR(ClientHttpRequestFactoryBuilder::reactor),
        JDK(ClientHttpRequestFactoryBuilder::jdk),
        SIMPLE(ClientHttpRequestFactoryBuilder::simple);

        private final Supplier<ClientHttpRequestFactoryBuilder<?>> builderSupplier;

        private Factory(Supplier<ClientHttpRequestFactoryBuilder<?>> builderSupplier) {
            this.builderSupplier = builderSupplier;
        }

        ClientHttpRequestFactoryBuilder<?> builder() {
            return this.builderSupplier.get();
        }
    }
}

