/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.hateoas.autoconfigure;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.hateoas.autoconfigure.HateoasProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.client.LinkDiscoverers;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.http.MediaType;
import org.springframework.plugin.core.Plugin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration
@ConditionalOnClass(value={EntityModel.class, RequestMapping.class, RequestMappingHandlerAdapter.class, Plugin.class, JsonMapper.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={HateoasProperties.class})
public final class HypermediaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBooleanProperty(name={"spring.hateoas.use-hal-as-default-json-media-type"}, matchIfMissing=true)
    HalConfiguration applicationJsonHalConfiguration() {
        return new HalConfiguration().withMediaType(MediaType.APPLICATION_JSON);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={LinkDiscoverers.class})
    @EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
    static class HypermediaConfiguration {
        HypermediaConfiguration() {
        }
    }
}

