/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.graphql.autoconfigure;

import java.time.Duration;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;

@ConfigurationProperties(value="spring.graphql")
public class GraphQlProperties {
    private final Http http = new Http();
    private final Graphiql graphiql = new Graphiql();
    private final Rsocket rsocket = new Rsocket();
    private final Schema schema = new Schema();
    private final Websocket websocket = new Websocket();

    public Http getHttp() {
        return this.http;
    }

    public Graphiql getGraphiql() {
        return this.graphiql;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Websocket getWebsocket() {
        return this.websocket;
    }

    public Rsocket getRsocket() {
        return this.rsocket;
    }

    public static class Http {
        private String path = "/graphql";
        private final Sse sse = new Sse();

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Sse getSse() {
            return this.sse;
        }
    }

    public static class Graphiql {
        private String path = "/graphiql";
        private boolean enabled;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Rsocket {
        private @Nullable String mapping;

        public @Nullable String getMapping() {
            return this.mapping;
        }

        public void setMapping(@Nullable String mapping) {
            this.mapping = mapping;
        }
    }

    public static class Schema {
        private String[] locations = new String[]{"classpath:graphql/**/"};
        private String[] fileExtensions = new String[]{".graphqls", ".gqls"};
        private Resource[] additionalFiles = new Resource[0];
        private final Inspection inspection = new Inspection();
        private final Introspection introspection = new Introspection();
        private final Printer printer = new Printer();

        public String[] getLocations() {
            return this.locations;
        }

        public void setLocations(String[] locations) {
            this.locations = this.appendSlashIfNecessary(locations);
        }

        public String[] getFileExtensions() {
            return this.fileExtensions;
        }

        public void setFileExtensions(String[] fileExtensions) {
            this.fileExtensions = fileExtensions;
        }

        public Resource[] getAdditionalFiles() {
            return this.additionalFiles;
        }

        public void setAdditionalFiles(Resource[] additionalFiles) {
            this.additionalFiles = additionalFiles;
        }

        private String[] appendSlashIfNecessary(String[] locations) {
            return (String[])Arrays.stream(locations).map(location -> location.endsWith("/") ? location : location + "/").toArray(String[]::new);
        }

        public Inspection getInspection() {
            return this.inspection;
        }

        public Introspection getIntrospection() {
            return this.introspection;
        }

        public Printer getPrinter() {
            return this.printer;
        }

        public static class Inspection {
            private boolean enabled = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }

        public static class Introspection {
            private boolean enabled = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }

        public static class Printer {
            private boolean enabled;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }
    }

    public static class Websocket {
        private @Nullable String path;
        private Duration connectionInitTimeout = Duration.ofSeconds(60L);
        private @Nullable Duration keepAlive;

        public @Nullable String getPath() {
            return this.path;
        }

        public void setPath(@Nullable String path) {
            this.path = path;
        }

        public Duration getConnectionInitTimeout() {
            return this.connectionInitTimeout;
        }

        public void setConnectionInitTimeout(Duration connectionInitTimeout) {
            this.connectionInitTimeout = connectionInitTimeout;
        }

        public @Nullable Duration getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(@Nullable Duration keepAlive) {
            this.keepAlive = keepAlive;
        }
    }

    public static class Sse {
        private @Nullable Duration keepAlive;
        private @Nullable Duration timeout;

        public @Nullable Duration getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(@Nullable Duration keepAlive) {
            this.keepAlive = keepAlive;
        }

        public @Nullable Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(@Nullable Duration timeout) {
            this.timeout = timeout;
        }
    }
}

